/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-bookmarklist.h"
#include "intl.h"
#include <sys/stat.h>

KzBookmark *bookmarklist_single = NULL;

KzBookmark *
kz_bookmark_list_new (void)
{
	KzBookmark *bookmarklist;
	gchar *bookmarkbarfile;
	struct stat st;

	/* build the filename */
        bookmarkbarfile = g_strconcat(g_get_home_dir(),
				      "/.kazehakase/bookmarkbar.xml",
				      NULL);
	/* use system wide config file if user's file isn't exist. */
	if (stat(bookmarkbarfile, &st))
	{
		gchar *system_bookmarkbarfile;
		system_bookmarkbarfile = g_strconcat(KZ_SYSCONFDIR,
					      "/bookmarkbar.xml",
					      NULL);
		bookmarklist = kz_bookmark_file_new(system_bookmarkbarfile,
						    _("Bookmark bar"),
						    "XBEL");
		g_free(system_bookmarkbarfile);
	}
	else
	{
		bookmarklist = kz_bookmark_file_new(bookmarkbarfile,
						    _("Bookmark bar"),
						    "XBEL");
	}

	kz_bookmark_load_in_memory_start(bookmarklist);

	kz_bookmark_set_location(bookmarklist, bookmarkbarfile);

	g_free(bookmarkbarfile);

	return bookmarklist;
}


KzBookmark *
kz_bookmark_list_get_instance (void)
{
	if (!bookmarklist_single)
		bookmarklist_single = kz_bookmark_list_new();
	else
		g_object_ref(bookmarklist_single);

	return bookmarklist_single;
}


void
kz_bookmark_list_set_list (KzBookmark *bookmarklist, GSList *new_list)
{
	GSList *node;

	g_return_if_fail(KZ_IS_BOOKMARK(bookmarklist));

	/* verify */
	for (node = new_list; node; node = g_slist_next(node))
	{
		KzBookmark *bookmark = node->data;
		g_return_if_fail(KZ_IS_BOOKMARK(bookmark));
	}

	kz_bookmark_remove_all(bookmarklist);

	if (new_list)
	{
		for (node = new_list; node; node = g_slist_next(node))
		{
			KzBookmark *bookmark = node->data;
			kz_bookmark_append(bookmarklist, bookmark);
			g_object_unref(bookmark);
		}
	}
}
