/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-history.h 482 2003-11-18 22:02:44Z makeinu $
 */

#ifndef __KZ_HISTORY_H__
#define __KZ_HISTORY_H__

#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_HISTORY			(kz_history_get_type ())
#define KZ_HISTORY(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_HISTORY, KzHistory))
#define KZ_HISTORY_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_HISTORY, KzHistoryClass))
#define KZ_IS_HISTORY(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_HISTORY))
#define KZ_IS_HISTORY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_HISTORY))
#define KZ_HISTORY_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_HISTORY, KzHistoryClass))

#define KZ_TYPE_HISTORY_TYPE		(kz_history_type_get_type())

typedef struct _KzHistory         KzHistory;
typedef struct _KzHistoryClass    KzHistoryClass;

struct _KzHistory
{
	KzBookmark parent;
};

struct _KzHistoryClass
{
	KzBookmarkClass parent_class;
};


GType		kz_history_get_type		(void);
KzBookmark     *kz_history_new			(const gchar *file);

G_END_DECLS

#endif /* __KZ_HISTORY_H__ */
