/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_FILE_H__
#define __KZ_FILE_H__

#include <glib-object.h>
#include "kz-io.h"

G_BEGIN_DECLS

#define KZ_TYPE_FILE		(kz_file_get_type ())
#define KZ_FILE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_FILE, KzFile))
#define KZ_FILE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_FILE, KzFileClass))
#define KZ_IS_FILE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_FILE))
#define KZ_IS_FILE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_FILE))
#define KZ_FILE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_FILE, KzFileClass))

typedef struct _KzFile KzFile;
typedef struct _KzFileClass KzFileClass;

struct _KzFile
{
	KzIO parent;
};

struct _KzFileClass
{
	KzIOClass parent_class;
};

KzFile *kz_file_new       (const gchar *uri, KzIOMode mode);

G_END_DECLS

#endif /* __KZ_FILE_H__ */
