/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_general.h"

#include "kazehakase.h"
#include "kz-window.h"
#include "kz-mozembed.h"
#include "mozilla-prefs.h"
#include "utils/intl.h"
#include "utils/gtk-utils.h"

#define DATA_KEY "KzPrefsGeneral::info"


static GtkWidget     *prefs_general_create          (void);
static void           prefs_general_response        (GtkWidget *widget,
						     gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/General"),
	priority_hint:   0,
	ui_level:        KZ_UI_LEVEL_ALL,
	create:          prefs_general_create,
	response:        prefs_general_response,
};


typedef struct _KzPrefsGeneral
{
	GtkWidget     *main_vbox;
	GtkWidget     *start_page_entry;
	GtkWidget     *override_check;
	GtkWidget     *user_agent_entry;
	GtkWidget     *keep_bookmark_menu;
	GtkWidget     *keep_bookmark_menu_frame;
	GtkWidget     *keep_bookmark_menu_vbox;
	GtkWidget     *open_in_new_tab;
	GtkWidget     *open_anything_as_uri;
	GtkOptionMenu *ui_menu;
	gboolean       changed;
} KzPrefsGeneral;


typedef struct
{
	gchar *title;
	gchar* code;
} UILevel;
static const UILevel ui_levels[] =
{
	{ N_("Beginner"),	"beginner" },
	{ N_("Medium"),		"medium" },
	{ N_("Expert"),		"expert" },
};
static const guint n_ui_levels = G_N_ELEMENTS (ui_levels);


static void
prefs_general_destroy (gpointer data)
{
	KzPrefsGeneral *prefsui = data;

	g_free(prefsui);
}


static void
cb_current_clicked (GtkWidget *widget, KzPrefsGeneral *prefsui)
{
	GtkWidget *top, *page;
	GtkWindow *kz;
	const gchar *url;

	if (!prefsui) return;
	if (!GTK_IS_ENTRY(prefsui->start_page_entry)) return;

	top = gtk_widget_get_toplevel(widget);
	if (!GTK_IS_WINDOW(top)) return;

	kz = gtk_window_get_transient_for(GTK_WINDOW(top));
	if (!KZ_IS_WINDOW(kz)) return;

	page = KZ_WINDOW_CURRENT_PAGE(KZ_WINDOW(kz));
	if (!KZ_IS_MOZ_EMBED(page)) return;

	url = kz_moz_embed_get_location(KZ_MOZ_EMBED(page));

	if (url && *url)
		gtk_entry_set_text(GTK_ENTRY(prefsui->start_page_entry), url);
}


static void
cb_blank_clicked (GtkWidget *widget, KzPrefsGeneral *prefsui)
{
	if (!prefsui) return;
	if (!GTK_IS_ENTRY(prefsui->start_page_entry)) return;

	gtk_entry_set_text(GTK_ENTRY(prefsui->start_page_entry),
			   "about:blank");
}


#if 0
static void
cb_user_agent_toggled(GtkToggleButton *button, KzPrefsGeneral *prefsui)
{
	gtk_widget_set_sensitive(prefsui->user_agent_entry,
				 gtk_toggle_button_get_active(button));
	prefsui->changed = TRUE;
}
#endif


static void
cb_changed (GtkWidget *widget, KzPrefsGeneral *prefsui)
{
	prefsui->changed = TRUE;
}


static GtkWidget *
prefs_general_create (void)
{
	KzPrefsGeneral *prefsui = g_new0(KzPrefsGeneral, 1);
	GtkWidget *main_vbox, *vbox, *hbox, *frame;
	GtkWidget *label, *entry, *button;
	GtkWidget *option_menu, *menu, *check;
	gchar *value;
	gboolean keep = FALSE, newtab = FALSE, asurl = FALSE;
#if 0
	GtkWidget *check;
	gboolean override = FALSE;
#endif

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_general_destroy);

	label = kz_prefs_ui_utils_create_title(_("General"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

	/*
	 *  Start Page
	 */
	frame = gtk_frame_new(_("Start page"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	/* description */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox,
			   FALSE, FALSE, 5);
	gtk_widget_show(hbox);

	label = gtk_label_new(_("If you want to set \"Home page\", "
				"please click right button of mouse "
				"on \"Home\" button of main window."));
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_box_pack_start(GTK_BOX(hbox), label,
			   FALSE, FALSE, 5);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_Location: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->start_page_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 2);
	gtk_widget_show(entry);

	value = KZ_CONF_GET_STR("Global", "startup_page");
	if (value)
	{
		gtk_entry_set_text(GTK_ENTRY(entry), value);
		g_free(value);
	}

	/* hbox = gtk_hbox_new(FALSE, 0); */
	hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	/* "Current page" button */
	button = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
	gtk_widget_show(button);

	label = gtk_label_new_with_mnemonic(_("Cu_rrent page"));
	gtk_container_add(GTK_CONTAINER(button), label);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), button);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(cb_current_clicked), prefsui);
	gtk_widget_show(label);

	/* "Blank page" button */
	button = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(hbox), button,FALSE, FALSE, 0);
	gtk_widget_show(button);

	label = gtk_label_new_with_mnemonic(_("_Blank page"));
	gtk_container_add(GTK_CONTAINER(button), label);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), button);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(cb_blank_clicked), prefsui);
	gtk_widget_show(label);

#if 0
	/*
	 *  User agent
	 */
	frame = gtk_frame_new(_("User agent"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Ove_rride user agent"));
	prefsui->override_check = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 0);
	KZ_CONF_GET("Global", "override_user_agent", override, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), override);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_user_agent_toggled), prefsui);
	gtk_widget_show(check);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_User-agent: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->user_agent_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
	gtk_widget_set_sensitive(entry, override);
	gtk_widget_show(entry);

	value = KZ_CONF_GET_STR("Global", "user_agent");
	if (value)
		gtk_entry_set_text(GTK_ENTRY(entry), value);
	g_free(value);
#endif
	/*
	 *  Bookmark menu
	 */
	frame = gtk_frame_new(_("Bookmark menu"));
	prefsui->keep_bookmark_menu_frame = frame;
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	prefsui->keep_bookmark_menu_vbox = vbox;
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Keep menu _open by middle click"));
	prefsui->keep_bookmark_menu = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "keep_bookmark_menu", keep, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), keep);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	/*
	 *  Entry Box behaviour
	 */
	frame = gtk_frame_new(_("Location entry and google entry"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Open in _new tab by default"));
	prefsui->open_in_new_tab = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "entry_open_in_new_tab", newtab, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), newtab);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("Open anything as _URI"));
	prefsui->open_anything_as_uri = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "entry_open_anything_as_uri", asurl, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), asurl);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	/*
	 *  UI Level
	 */
	frame = gtk_frame_new(NULL);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_UI Level: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	option_menu = gtk_option_menu_new();
	prefsui->ui_menu = GTK_OPTION_MENU(option_menu);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), option_menu);
	gtk_box_pack_start(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
	gtk_widget_show(option_menu);

	GTKUTIL_CREATE_MENU(menu, ui_levels, n_ui_levels, title);
	gtk_option_menu_set_menu (GTK_OPTION_MENU(option_menu), menu);
	value = KZ_CONF_GET_STR("Global", "ui_level");
	GTKUTIL_SET_DEFAULT_HISTORY(option_menu, value,
				    ui_levels, n_ui_levels, code);
	g_free(value);
	g_signal_connect (G_OBJECT(option_menu), "changed",
			  G_CALLBACK (cb_changed), prefsui);
	gtk_widget_show(menu);

	prefsui->changed = FALSE;

	return main_vbox;
}



static void
prefs_general_response (GtkWidget *widget, gint response)
{
	KzPrefsGeneral *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		const gchar *value;
		gboolean keep, newtab, asuri;
#if 0
		gboolean override;
#endif
		gint i;

		/* statrup */
		value = gtk_entry_get_text(GTK_ENTRY(prefsui->start_page_entry));
		KZ_CONF_SET_STR("Global", "startup_page", value);

#if 0
		/* user agent */
		override = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->override_check));
		KZ_CONF_SET("Global", "override_user_agent", override, BOOL);

		value = gtk_entry_get_text(GTK_ENTRY(prefsui->user_agent_entry));
		KZ_CONF_SET("Global", "user_agent", value, BOOL);
		if (override)
		{
			mozilla_prefs_set_string("general.useragent.override", value);
		}
		else
		{
			/* FIXME: set to the default user agent */
		}
#endif
		/* Bookmark menu */
		keep = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->keep_bookmark_menu));
		KZ_CONF_SET("Global", "keep_bookmark_menu", keep, BOOL);

		/* entry box behaviour */
		newtab = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->open_in_new_tab));
		KZ_CONF_SET("Global", "entry_open_in_new_tab", newtab, BOOL);

		/* entry box behaviour */
		asuri = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->open_anything_as_uri));
		KZ_CONF_SET("Global", "entry_open_anything_as_uri", asuri, BOOL);

		/* UI level */
		if (prefsui->changed)
		{
			i = gtk_option_menu_get_history(prefsui->ui_menu);
			if (i >= 0 && i < n_ui_levels)
				KZ_CONF_SET_STR("Global", "ui_level",
						ui_levels[i].code);
		}

		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_BEGINNER:
	{
		gchar *value;
		value = KZ_CONF_GET_STR("Global", "ui_level");
		GTKUTIL_SET_DEFAULT_HISTORY(prefsui->ui_menu, value,
					    ui_levels, n_ui_levels, code);
		g_free(value);

		/* URI Entry */
		gtk_widget_hide(prefsui->open_anything_as_uri);
		gtk_widget_hide(prefsui->open_anything_as_uri);
		/* Bookmark menu */
		gtk_widget_hide(prefsui->keep_bookmark_menu_frame);
		gtk_widget_hide(prefsui->keep_bookmark_menu_vbox);
		break;
	}
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
	{
		gchar *value;
		value = KZ_CONF_GET_STR("Global", "ui_level");
		GTKUTIL_SET_DEFAULT_HISTORY(prefsui->ui_menu, value,
					    ui_levels, n_ui_levels, code);
		g_free(value);	

		/* URI Entry */
		gtk_widget_hide(prefsui->open_anything_as_uri);
		gtk_widget_hide(prefsui->open_anything_as_uri);
		/* Bookmark menu */
		gtk_widget_hide(prefsui->keep_bookmark_menu_frame);
		gtk_widget_hide(prefsui->keep_bookmark_menu_vbox);
		break;
	}
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
	{
		gchar *value;
		value = KZ_CONF_GET_STR("Global", "ui_level");
		GTKUTIL_SET_DEFAULT_HISTORY(prefsui->ui_menu, value,
					    ui_levels, n_ui_levels, code);
		g_free(value);
	
		/* URI Entry */
		gtk_widget_show(prefsui->open_anything_as_uri);
		gtk_widget_show(prefsui->open_anything_as_uri);	
		/* Bookmark menu */
		gtk_widget_show(prefsui->keep_bookmark_menu_frame);
		gtk_widget_show(prefsui->keep_bookmark_menu_vbox);
		break;
	}
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_general_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
