// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2003 Takuro Ashie
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include <xpcom/nsCOMPtr.h>
#include <docshell/nsIDocShell.h>
#include <dom/nsIDOMDocument.h>
#include <dom/nsIDOMWindow.h>
#include <dom/nsIDOMRange.h>
#include <webbrwsr/nsIWebBrowser.h>
#include <nsString.h>
#include <nsIDOMEventReceiver.h>
#include <nsPIDOMWindow.h>
#include <nsIWebNavigation.h>
#include <nsISHistory.h>
#include <nsICacheEntryDescriptor.h>
#include <nsIPrintOptions.h>
#include "kz-mozembed.h"
#include "kz-mozselectionlistener.h"
#include "kz-mozeventlistener.h"


class KzMozWrapper
{
public:
	KzMozWrapper ();
	virtual ~KzMozWrapper ();

	nsresult Init    (KzMozEmbed *kzembed);
	void     Destroy (void);

	//
	// Our own methods
	//

	nsresult GetDocShell        (nsIDocShell    **docShell);
	nsresult GetMainDomDocument (nsIDOMDocument **doc);
	nsresult GetDOMWindow	    (nsIDOMWindow   **aDOMWindow);
	nsresult GetDocument        (nsIDOMDocument **doc);
	nsresult GetDocumentUrl     (nsCString &url);
	nsresult GetContentViewer   (nsIContentViewer **aViewer);

	nsresult CanCutSelection  (PRBool *result);
	nsresult CanCopySelection (PRBool *result);
	nsresult CanPaste         (PRBool *result);
	nsresult CutSelection     (void);
	nsresult CopySelection    (void);
	nsresult Paste            (void);
	nsresult SelectAll        (void);

	// for selection
	nsresult GetSelection            (nsISelection **selection);
	nsresult GetSelectionSource      (nsISelection *selection,
					  PRBool useLocalImage,
					  nsAString &string);

	nsresult GetBodyString           (nsAString &string);
   
	nsresult GetPageDescriptor (nsISupports **aPageDescriptor);
	nsresult LoadDocument      (nsISupports *aPageDescriptor,
				    PRUint32 aDisplayType);

	nsresult ForceEncoding     (const char *encoding);
	nsresult GetEncoding       (char **encoding,
				    PRBool& forced);

	nsresult CopyHistoryTo     (KzMozWrapper *dest, 
				    PRBool back_history, 
				    PRBool forward_history, 
				    PRBool set_current);
	nsresult GetSHInfo         (PRInt32 *count, PRInt32 *index);
	nsresult GetSHUrlAtIndex   (PRInt32 index, nsCString &url);
	nsresult GetSHTitleAtIndex (PRInt32 index, PRUnichar **title);
	nsresult ResolveURI        (const nsAString &origURI, nsACString &URI);

	nsresult Print             (void);
	nsresult PrintPreview      (void);

	nsCOMPtr<nsIWebBrowser>    mWebBrowser;
protected:
	nsCOMPtr<nsIDOMEventReceiver> mEventReceiver;
	nsCOMPtr<nsIDOMWindow>        mDOMWindow;
	KzMozEmbed             *mKzMozEmbed;
	KzMozEventListener     *mKzMozEventListener;
	KzMozSelectionListener *mKzMozSelectionListener;
	PRPackedBool            mSelectionWasCollapsed;

	nsresult GetListener (void);
	nsresult AttachListeners (void);
	nsresult DetachListeners (void);
	nsresult GetWebNavigation(nsIWebNavigation **aWebNavigation);
	nsresult GetFocusedDOMWindow (nsIDOMWindow **aDOMWindow);
	nsresult GetSHistory (nsISHistory **aSHistory);
	void     HTMLSourceFromNode (nsIDOMNode *node,
				     nsISelection *selection,
				     nsIDOMRange *range,
				     PRBool useLocalImage,
				     nsAString &string);
	void     MoveImageToLocal   (const nsACString &URI,
				     nsAString &LocalFile);

	nsresult GetCacheEntryDescriptor(const nsAString &aKey,
					 nsICacheEntryDescriptor **aCacheEntryDescriptor);
};
