/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmarks-view.h 813 2004-03-25 04:32:23Z makeinu $
 */

#ifndef __KZ_BOOKMARKS_VIEW_H__
#define __KZ_BOOKMARKS_VIEW_H__

#include <gtk/gtk.h>
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARKS_VIEW			(kz_bookmarks_view_get_type ())
#define KZ_BOOKMARKS_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARKS_VIEW, KzBookmarksView))
#define KZ_BOOKMARKS_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BOOKMARKS_VIEW, KzBookmarksViewClass))
#define KZ_IS_BOOKMARKS_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARKS_VIEW))
#define KZ_IS_BOOKMARKS_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BOOKMARKS_VIEW))
#define KZ_BOOKMARKS_VIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BOOKMARKS_VIEW, KzBookmarksViewClass))

typedef struct _KzBookmarksView		KzBookmarksView;
typedef struct _KzBookmarksViewClass	KzBookmarksViewClass;
typedef struct _KzBookmarksViewPriv	KzBookmarksViewPriv;

struct _KzBookmarksView
{
	GtkTreeView parent;

	KzBookmark *root_folder;

	KzBookmarksViewPriv *priv;
};

struct _KzBookmarksViewClass
{
	GtkTreeViewClass parent_class;
};

GtkType       kz_bookmarks_view_get_type        (void);
GtkWidget    *kz_bookmarks_view_new             (void);
void          kz_bookmarks_view_set_root_folder (KzBookmarksView *view,
						 KzBookmark      *root_folder,
						 gboolean         tree_mode,
						 gboolean         include_top,
						 gboolean         folder_only,
						 gboolean         editable);
KzBookmark   *kz_bookmarks_view_get_bookmark    (GtkTreeModel    *model,
						 GtkTreeIter     *iter);
void          kz_bookmarks_view_select          (KzBookmarksView *view,
						 KzBookmark      *bookmark);

G_END_DECLS

#endif /* __KZ_BOOKMARKS_VIEW_H__ */
