/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_TAB_LABEL_H__
#define __KZ_TAB_LABEL_H__

#include <gtk/gtk.h>

#include "gtk24backports.h"
#include "kz-mozembed.h"
#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_TAB_LABEL		(kz_tab_label_get_type ())
#define KZ_TAB_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_TAB_LABEL, KzTabLabel))
#define KZ_TAB_LABEL_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_TAB_LABEL, KzTabLabelClass))
#define KZ_IS_TAB_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_TAB_LABEL))
#define KZ_IS_TAB_LABEL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_TAB_LABEL))
#define KZ_TAB_LABEL_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_TAB_LABEL, KzTabLabelClass))

typedef struct _KzTabLabel           KzTabLabel;
typedef struct _KzTabLabelClass      KzTabLabelClass;
typedef struct _KzTabLabelPriv       KzTabLabelPriv;

typedef enum
{
	KZ_TAB_LABEL_STATE_NORMAL,
	KZ_TAB_LABEL_STATE_LOADING,
	KZ_TAB_LABEL_STATE_LOADED,
	KZ_TAB_LABEL_N_STATE
} KzTabLabelState;


struct _KzTabLabel
{
	GtkHBox parent;

	KzWindow        *kz;
	KzMozEmbed      *kzembed;

	KzTabLabelState  state;

	GtkWidget       *favicon;
	GtkWidget       *eventbox;
	GtkWidget       *label;
	GtkWidget       *close_button;
	GtkWidget       *lock_button;

	GtkTooltips     *tooltips;
	GdkBitmap       *mask;
	GdkPixbuf       *favicon_pixbuf;
	GdkPixmap       *circle;

	KzTabLabelPriv  *priv;
};

struct _KzTabLabelClass
{
	GtkHBoxClass parent_class;
};

GtkType          kz_tab_label_get_type          (void);
GtkWidget       *kz_tab_label_new               (KzWindow *kz,
						 KzMozEmbed *kzembed);

void             kz_tab_label_set_text          (KzTabLabel *kztab,
						 const gchar *text);
void             kz_tab_label_set_state         (KzTabLabel *kztab,
						 KzTabLabelState state);
KzTabLabelState  kz_tab_label_get_state         (KzTabLabel *kztab);

void             kz_tab_label_set_width         (KzTabLabel *kztab,
						 gint        width);
void             kz_tab_label_set_show_close_button
						(KzTabLabel *kztab,
						 gboolean    show);
gboolean         kz_tab_label_get_lock          (KzTabLabel *kztab);
void             kz_tab_label_set_lock          (KzTabLabel *kztab,
						 gboolean    lock);
G_END_DECLS

#endif /* __KZ_TAB_LABEL_H__ */
