/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003-2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "kz-embed-event.h"

#ifndef __KZ_EMBED_H__
#define __KZ_EMBED_H__

G_BEGIN_DECLS

#define KZ_TYPE_EMBED		(kz_embed_get_type())
#define KZ_EMBED(o)		(G_TYPE_CHECK_INSTANCE_CAST((o), KZ_TYPE_EMBED), KzEmbed)
#define KZ_IS_EMBED(o)		(G_TYPE_CHECK_INSTANCE_TYPE(o), KZ_TYPE_EMBED)
#define KZ_EMBED_GET_IFACE(o)	(G_TYPE_INSTANCE_GET_INTERFACE((o)), KZ_TYPE_EMBED, KzEmbedIFace)

typedef struct _KzEmbed      KzEmbed;
typedef struct _KzEmbedIFace KzEmbedIFace;

typedef enum {
	KZ_EMBED_NORMAL_FLAG = 0,
	KZ_EMBED_SOURCE_FLAG = 1 << 0
} KzEmbedLoadFlag;

typedef enum {
	KZ_EMBED_RELOAD_HOGEHOGE_FLAG
} KzEmbedReloadFlag;

typedef enum {
	KZ_EMBED_GO_NONE,
	KZ_EMBED_GO_BACK,
	KZ_EMBED_GO_FORWARD,
	KZ_EMBED_GO_UP,
	KZ_EMBED_GO_INDEX,
	KZ_EMBED_GO_CONTENTS,
	KZ_EMBED_GO_START,
	KZ_EMBED_GO_PREV,
	KZ_EMBED_GO_NEXT
} KzEmbedGoAction;

struct _KzEmbedIFace {
	GTypeInterface g_iface;

	/* vtable */
	/*
	 *  simple setters and getters will be implemented
	 *  as GObject's property.
	 */
	void     (*load)                (KzEmbed     *embed,
					 const gchar *uri,
					 KzEmbedLoadFlag *flags);
	void     (*relaod)              (KzEmbed     *embed,
					 KzEmbedReloadFlag flags);
	void     (*stop)                (KzEmbed     *embed);
	void     (*go)                  (KzEmbed     *embed,
					 KzEmbedGoAction action);
	gboolean (*find)                (KzEmbed     *embed,
					 const gchar *keyword,
					 gboolean     backword,
					 gboolean     inclemental);
#if 0
	/*
	 * I want to implement simple miscellaneous actions as GtkAction,
	 * but I'm not sure whether it's suitable way or not.
	 */
	void     (*cut_selection)       (KzEmbed     *embed);
	void     (*copy_selection)      (KzEmbed     *embed);
	void     (*paste)               (KzEmbed     *embed);
	void     (*undo)                (KzEmbed     *embed);
	void     (*redo)                (KzEmbed     *embed);
	void     (*print)               (KzEmbed     *embed);
	void     (*print_preview)       (KzEmbed     *embed);
#endif

	/* signals */
	void     (*link_message)        (KzEmbed      *embed);
	void     (*js_status)           (KzEmbed      *embed);
	void     (*location)            (KzEmbed      *embed);
	void     (*title)               (KzEmbed      *embed);
	void     (*progress)            (KzEmbed      *embed,
					 const char   *uri,
					 gint          curprogress,
					 gint          maxprogress);
	void     (*net_state)           (KzEmbed      *embed,
					 const char   *uri,
					 gint          state,
					 guint         status);
	void     (*net_start)           (KzEmbed      *embed);
	void     (*net_stop)            (KzEmbed      *embed);
	void     (*new_window)          (KzEmbed      *embed,
					 KzEmbed     **newEmbed,
					 guint         chromemask);
	void     (*visibility)          (KzEmbed      *embed,
					 gboolean      visibility);
	void     (*destroy_embed)       (KzEmbed      *embed);
	gint     (*open_uri)            (KzEmbed      *embed,
					 const char   *uri);
	void     (*size_to)             (KzEmbed      *embed,
					 gint          width,
					 gint          height);
	gint     (*dom_key_down)        (KzEmbed      *embed,
					 KzEmbedEvent *event);
	gint     (*dom_key_press)       (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_key_up)          (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_down)      (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_up)        (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_click)     (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_dbl_click) (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_over)      (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_out)       (KzEmbed      *embed,
					 KzEmbedEvent  event);
	void     (*security_change)     (KzEmbed      *embed,
					 gpointer      request,
					 guint         state);
	void     (*status_change)       (KzEmbed      *embed,
					 gpointer      request,
					 gint          status,
					 gpointer      message);
};

GType kz_embed_get_type (void);

G_END_DECLS

#endif /* __KZ_EMBED_H__ */
