/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#include <gtk/gtkvbox.h>
#include <gtk/gtkcombobox.h>
#include <gtk/gtkbutton.h>

#include "kz-window.h"

#ifndef __KZ_SIDEBAR_H__
#define __KZ_SIDEBAR_H__

#define KZ_TYPE_SIDEBAR			(kz_sidebar_get_type ())
#define KZ_SIDEBAR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_SIDEBAR, KzSidebar))
#define KZ_SIDEBAR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_SIDEBAR, KzSidebarClass))
#define KZ_IS_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_SIDEBAR))
#define KZ_IS_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_SIDEBAR))
#define KZ_SIDEBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_SIDEBAR, KzSidebarClass))

typedef struct _KzSidebar	KzSidebar;
typedef struct _KzSidebarClass	KzSidebarClass;
typedef struct _KzSidebarPriv	KzSidebarPriv;
typedef struct _KzSidebarEntry	KzSidebarEntry;

struct _KzSidebar
{
	GtkVBox parent;

	KzWindow       *kz;

	GtkWidget      *hbox;
	GtkWidget      *option_menu;
	GtkWidget      *close_button;

	GtkWidget      *content;

	KzSidebarEntry *current_entry;
};

struct _KzSidebarClass
{
	GtkVBoxClass parent_class;
};

struct _KzSidebarEntry
{
	gint         priority_hint;
	const gchar *label;
	const gchar *icon; /* icon stock */
	GtkWidget   *(*create) (KzSidebar *kz);
};

GtkType	          kz_sidebar_get_type           (void);
GtkWidget        *kz_sidebar_new                (KzWindow *kz);
gboolean          Kz_sidebar_append_item        (KzSidebarEntry *item);
const gchar      *kz_sidebar_get_current        (KzSidebar *Sidebar);
gboolean          kz_sidebar_set_current        (KzSidebar *sidebar,
						 const gchar *label);

#endif /* __KZ_SIDEBAR_H__ */
