/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004  Hidetaka Iwai
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_external_program.h"

#include <glib/gi18n.h>
#include "kazehakase.h"
#include "utils/gtk-utils.h"

#define DATA_KEY "KzPrefsExternalProgram::info"

static GtkWidget     *prefs_external_program_create      (void);
static void           prefs_external_program_response    (GtkWidget *widget,
							  gint       response);

static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/External Program"),
	priority_hint:   0,
	ui_level:        KZ_UI_LEVEL_EXPERT,
	create:          prefs_external_program_create,
	response:        prefs_external_program_response,
};

typedef struct _KzPrefsExternalProgram
{
	GtkWidget     *main_vbox;
	GtkWidget     *editor_entry;
#if USE_MIGEMO
	GtkWidget     *migemo_check;
	GtkWidget     *migemo_entry;
#endif /* USE_MIGEMO */
	gboolean      changed;
} KzPrefsExternalProgram;

#if USE_MIGEMO
static void
cb_changed (GtkWidget *widget, KzPrefsExternalProgram *prefsui)
{
	prefsui->changed = TRUE;
}
#endif /* USE_MIGEMO */

static void
prefs_external_program_destroy (gpointer data)
{
	KzPrefsExternalProgram *prefsui = data;

	g_free(prefsui);
}

static GtkWidget *
prefs_external_program_create (void)
{
	KzPrefsExternalProgram *prefsui = g_new0(KzPrefsExternalProgram, 1);
	GtkWidget *main_vbox, *vbox, *hbox, *frame;
	GtkWidget *label, *entry;
	gchar* value;
#if USE_MIGEMO
	GtkWidget *check;
	gboolean use_migemo;
#endif /* USE_MIGEMO */

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_external_program_destroy);

	label = kz_prefs_ui_utils_create_title(_("External Program"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

        /*
	 * external editor entry
	 */
	frame = gtk_frame_new(_("Editor"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_Editor command: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->editor_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 2);
	gtk_widget_show(entry);

	value = KZ_CONF_GET_STR("Global", "editor_command");
	if (value)
	{
		gtk_entry_set_text(GTK_ENTRY(entry), value);
		g_free(value);
	}

#if USE_MIGEMO
	/* migemo */
	frame = gtk_frame_new(_("Migemo"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	check = gtk_check_button_new_with_mnemonic(_("_Use migemo"));
	prefsui->migemo_check = check;
	gtk_box_pack_start(GTK_BOX(hbox), check, FALSE, FALSE, 2);
	use_migemo = FALSE;
	KZ_CONF_GET("Global", "use_migemo", use_migemo, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), use_migemo);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_Migemo command: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->migemo_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 2);
	gtk_widget_show(entry);

	value = KZ_CONF_GET_STR("Global", "migemo_command");
	if (value)
	{
		gtk_entry_set_text(GTK_ENTRY(entry), value);
		g_free(value);
	}

#endif /* USE_MIGEMO */

	prefsui->changed = FALSE;

	return main_vbox;
}


static void
prefs_external_program_response (GtkWidget *widget, gint response)
{
	KzPrefsExternalProgram *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		const gchar* value;
#if USE_MIGEMO
		gboolean use_migemo;
#endif /* USE_MIGEMO */

		value = gtk_entry_get_text(GTK_ENTRY(prefsui->editor_entry));
		KZ_CONF_SET_STR("Global", "editor_command", value);

#if USE_MIGEMO
		use_migemo = gtk_toggle_button_get_active
		       (GTK_TOGGLE_BUTTON(prefsui->migemo_check));
		KZ_CONF_SET("Global", "use_migemo", use_migemo, BOOL);

		value = gtk_entry_get_text(GTK_ENTRY(prefsui->migemo_entry));
		KZ_CONF_SET_STR("Global", "migemo_command", value);
#endif /* USE_MIGEMO */
		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
		break;
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
		break;
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}

KzPrefsWinPageEntry *
prefs_external_program_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
