/* 
 * Copyright (C) 2004 Hiroyuki Ikezoe <poincare@ikezoe.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * The original code is gtkcomboboxentry.h in GTK-2.4.4. 
 * Copyright (C) 2002, 2003  Kristian Rietveld <kris@gtk.org>
 */

#ifndef __KZ_COMBO_BOX_ENTRY_H__
#define __KZ_COMBO_BOX_ENTRY_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_COMBO_BOX_ENTRY             (kz_combo_box_entry_get_type ())
#define KZ_COMBO_BOX_ENTRY(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_COMBO_BOX_ENTRY, KzComboBoxEntry))
#define KZ_COMBO_BOX_ENTRY_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), KZ_TYPE_COMBO_BOX_ENTRY, KzComboBoxEntryClass))
#define KZ_IS_COMBO_BOX_ENTRY(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_COMBO_BOX_ENTRY))
#define KZ_IS_COMBO_BOX_ENTRY_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), KZ_TYPE_COMBO_BOX_ENTRY))
#define KZ_COMBO_BOX_ENTRY_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_CLASS ((inst), KZ_TYPE_COMBO_BOX_ENTRY, KzComboBoxEntryClass))

typedef struct _KzComboBoxEntry             KzComboBoxEntry;
typedef struct _KzComboBoxEntryClass        KzComboBoxEntryClass;
typedef struct _KzComboBoxEntryPrivate      KzComboBoxEntryPrivate;

struct _KzComboBoxEntry
{
	GtkComboBox parent_instance;

	/*< private >*/
	KzComboBoxEntryPrivate *priv;
};

struct _KzComboBoxEntryClass
{
	GtkComboBoxClass parent_class;
};


GType       kz_combo_box_entry_get_type        (void);
GtkWidget  *kz_combo_box_entry_new             (void);
GtkWidget  *kz_combo_box_entry_new_with_model  (GtkTreeModel     *model,
                                                gint              text_column);

void        kz_combo_box_entry_set_text_column (KzComboBoxEntry *entry_box,
                                                gint             text_column);
gint        kz_combo_box_entry_get_text_column (KzComboBoxEntry *entry_box);

/* convenience -- text */
GtkWidget  *kz_combo_box_entry_new_text        (void);


G_END_DECLS

#endif /* __KZ_COMBO_BOX_ENTRY_H__ */
