/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_general.h"

#include <glib/gi18n.h>
#include "kazehakase.h"
#include "kz-window.h"
#include "kz-embed.h"
#include "mozilla-prefs.h"
#include "utils/gtk-utils.h"

#define DATA_KEY "KzPrefsGeneral::info"


static GtkWidget     *prefs_general_create          (void);
static void           prefs_general_response        (GtkWidget *widget,
						     gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/General"),
	priority_hint:   0,
	ui_level:        KZ_UI_LEVEL_ALL,
	create:          prefs_general_create,
	response:        prefs_general_response,
};


typedef struct _KzPrefsGeneral
{
	GtkWidget     *main_vbox;
	GtkWidget     *override_check;
	GtkWidget     *user_agent_entry;
	GtkWidget     *keep_bookmark_menu;
	GtkWidget     *confirm_open_bookmarks;
	GtkWidget     *bookmark_menu_frame;
	GtkWidget     *bookmark_menu_vbox;
	GtkWidget     *open_in_new_tab;
	GtkWidget     *create_thumbnail;
	GtkWidget     *save_check;
	GtkWidget     *restore_check;
	GtkComboBox   *ui_menu;
	gboolean       changed;
} KzPrefsGeneral;


typedef struct
{
	gchar *title;
	gchar* code;
} UILevel;
static const UILevel ui_levels[] =
{
	{ N_("Beginner"),	"beginner" },
	{ N_("Medium"),		"medium" },
	{ N_("Expert"),		"expert" },
};
static const guint n_ui_levels = G_N_ELEMENTS (ui_levels);


static void
prefs_general_destroy (gpointer data)
{
	KzPrefsGeneral *prefsui = data;

	g_free(prefsui);
}


#if 0
static void
cb_user_agent_toggled(GtkToggleButton *button, KzPrefsGeneral *prefsui)
{
	gtk_widget_set_sensitive(prefsui->user_agent_entry,
				 gtk_toggle_button_get_active(button));
	prefsui->changed = TRUE;
}
#endif


static void
cb_changed (GtkWidget *widget, KzPrefsGeneral *prefsui)
{
	prefsui->changed = TRUE;
}


static GtkWidget *
prefs_general_create (void)
{
	KzPrefsGeneral *prefsui = g_new0(KzPrefsGeneral, 1);
	GtkWidget *main_vbox, *vbox, *hbox, *frame;
	GtkWidget *label;
	GtkWidget *option_menu, *check;
	gchar *value;
	gboolean keep = FALSE, newtab = FALSE, confirm = TRUE;
	gboolean thumbnail = FALSE;
	gboolean save, restore;
#if 0
	GtkWidget *check;
	gboolean override = FALSE;
#endif

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_general_destroy);

	label = kz_prefs_ui_utils_create_title(_("General"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

#if 0
	/*
	 *  User agent
	 */
	frame = gtk_frame_new(_("User agent"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Ove_rride user agent"));
	prefsui->override_check = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 0);
	KZ_CONF_GET("Global", "override_user_agent", override, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), override);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_user_agent_toggled), prefsui);
	gtk_widget_show(check);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_User-agent: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->user_agent_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
	gtk_widget_set_sensitive(entry, override);
	gtk_widget_show(entry);

	value = KZ_CONF_GET_STR("Global", "user_agent");
	if (value)
		gtk_entry_set_text(GTK_ENTRY(entry), value);
	g_free(value);
#endif
	/*
	 *  Bookmark menu
	 */
	frame = gtk_frame_new(_("Bookmark menu"));
	prefsui->bookmark_menu_frame = frame;
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	prefsui->bookmark_menu_vbox = vbox;
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Keep menu _open by middle click"));
	prefsui->keep_bookmark_menu = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "keep_bookmark_menu", keep, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), keep);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("_Confirmation of opening all bookmarks in bookmark folder"));
	prefsui->confirm_open_bookmarks = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "confirm_open_bookmarks", confirm, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), confirm);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	/*
	 *  Entry Box behaviour
	 */
	frame = gtk_frame_new(_("Location entry and search entry"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Open in _new tab by default"));
	prefsui->open_in_new_tab = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "entry_open_in_new_tab", newtab, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), newtab);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	/*
	 *  Thumbnail 
	 */
	frame = gtk_frame_new(_("Thumbnail"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("Create thumbnail"));
	prefsui->create_thumbnail = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	KZ_CONF_GET("Global", "create_thumbnail", thumbnail, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), thumbnail);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	/*
	 * Session
	 */
	frame = gtk_frame_new(_("Session"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	check = gtk_check_button_new_with_mnemonic(_("_Save session automatically"));
	prefsui->save_check = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	save = TRUE;
	KZ_CONF_GET("Session", "save", save, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), save);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_mnemonic(_("_Restore last saved session on startup"));
	prefsui->restore_check = check;
	gtk_box_pack_start(GTK_BOX(vbox), check, FALSE, FALSE, 2);
	restore = TRUE;
	KZ_CONF_GET("Session", "restore", restore, BOOL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), restore);
	g_signal_connect(G_OBJECT(check), "toggled",
			 G_CALLBACK(cb_changed), prefsui);
	gtk_widget_show(check);

	/*
	 *  UI Level
	 */
	frame = gtk_frame_new(NULL);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_UI Level: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	option_menu = gtk_combo_box_new_text();
	prefsui->ui_menu = GTK_COMBO_BOX(option_menu);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), option_menu);
	gtk_box_pack_start(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
	gtk_widget_show(option_menu);

	GTKUTIL_CREATE_MENU(option_menu, ui_levels, n_ui_levels, title);
	value = KZ_CONF_GET_STR("Global", "ui_level");
	GTKUTIL_SET_DEFAULT_HISTORY(option_menu, value,
				    ui_levels, n_ui_levels, code);
	g_free(value);
	g_signal_connect (G_OBJECT(option_menu), "changed",
			  G_CALLBACK (cb_changed), prefsui);

	prefsui->changed = FALSE;

	return main_vbox;
}



static void
prefs_general_response (GtkWidget *widget, gint response)
{
	KzPrefsGeneral *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		gboolean keep, newtab, thumbnail;
		gboolean save, restore;
#if 0
		gboolean override;
#endif
		guint i;

#if 0
		/* user agent */
		override = gtk_toggle_button_get_active
				(GTK_TOGGLE_BUTTON(prefsui->override_check));
		KZ_CONF_SET("Global", "override_user_agent", override, BOOL);

		value = gtk_entry_get_text(GTK_ENTRY(prefsui->user_agent_entry));
		KZ_CONF_SET("Global", "user_agent", value, BOOL);
		if (override)
		{
			mozilla_prefs_set_string("general.useragent.override", value);
		}
		else
		{
			/* FIXME: set to the default user agent */
		}
#endif
		/* Bookmark menu */
		keep = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->keep_bookmark_menu));
		KZ_CONF_SET("Global", "keep_bookmark_menu", keep, BOOL);

		keep = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->confirm_open_bookmarks));
		KZ_CONF_SET("Global", "confirm_open_bookmarks", keep, BOOL);
		
		/* entry box behaviour */
		newtab = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->open_in_new_tab));
		KZ_CONF_SET("Global", "entry_open_in_new_tab", newtab, BOOL);

		/* thumbnail */
		thumbnail = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON(prefsui->create_thumbnail));
		KZ_CONF_SET("Global", "create_thumbnail", thumbnail, BOOL);

		/* session */
		save = gtk_toggle_button_get_active
		       (GTK_TOGGLE_BUTTON(prefsui->save_check));
		KZ_CONF_SET("Session", "save", save, BOOL);

		restore = gtk_toggle_button_get_active
			  (GTK_TOGGLE_BUTTON(prefsui->restore_check));
		KZ_CONF_SET("Session", "restore", restore, BOOL);

		/* UI level */
		if (prefsui->changed)
		{
			i = gtk_combo_box_get_active(prefsui->ui_menu);
			if (i >= 0 && i < n_ui_levels)
				KZ_CONF_SET_STR("Global", "ui_level",
						ui_levels[i].code);
		}

		prefsui->changed = FALSE;

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	case KZ_RESPONSE_UI_LEVEL_BEGINNER:
	{
		gchar *value;
		value = KZ_CONF_GET_STR("Global", "ui_level");
		GTKUTIL_SET_DEFAULT_HISTORY(prefsui->ui_menu, value,
					    ui_levels, n_ui_levels, code);
		g_free(value);

		/* Bookmark menu */
		gtk_widget_hide(prefsui->bookmark_menu_frame);
		gtk_widget_hide(prefsui->bookmark_menu_vbox);
		break;
	}
	case KZ_RESPONSE_UI_LEVEL_MEDIUM:
	{
		gchar *value;
		value = KZ_CONF_GET_STR("Global", "ui_level");
		GTKUTIL_SET_DEFAULT_HISTORY(prefsui->ui_menu, value,
					    ui_levels, n_ui_levels, code);
		g_free(value);	

		/* Bookmark menu */
		gtk_widget_hide(prefsui->bookmark_menu_frame);
		gtk_widget_hide(prefsui->bookmark_menu_vbox);
		break;
	}
	case KZ_RESPONSE_UI_LEVEL_EXPERT:
	{
		gchar *value;
		value = KZ_CONF_GET_STR("Global", "ui_level");
		GTKUTIL_SET_DEFAULT_HISTORY(prefsui->ui_menu, value,
					    ui_levels, n_ui_levels, code);
		g_free(value);
	
		/* Bookmark menu */
		gtk_widget_show(prefsui->bookmark_menu_frame);
		gtk_widget_show(prefsui->bookmark_menu_vbox);
		break;
	}
	case KZ_RESPONSE_UI_LEVEL_CUSTOM:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_general_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
