
// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2004 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "kz-mozprintingpromptservice.h"

#include <unistd.h>
#include <errno.h>

#include <nsIDOMWindow.h>
#include <nsString.h>

#include "kz-print-dialog.h"
#include "gtk-utils.h"
#include "kz-mozutils.h"


NS_IMPL_ISUPPORTS1 (KzMozPrintingPromptService, nsIPrintingPromptService)

KzMozPrintingPromptService::KzMozPrintingPromptService ()
{
  NS_INIT_ISUPPORTS();
}


KzMozPrintingPromptService::~KzMozPrintingPromptService ()
{
}

NS_IMETHODIMP
KzMozPrintingPromptService::ShowPrintDialog (nsIDOMWindow *parent, 
		       			     nsIWebBrowserPrint *webBrowserPrint,
					     nsIPrintSettings *printSettings)
{
	gint result;
	GtkWidget *kz = GetGtkWindowForDOMWindow(parent);
	GtkWidget *dialog = kz_print_dialog_new(KZ_WINDOW(kz));

	result = gtk_dialog_run(GTK_DIALOG(dialog));

	if (result != GTK_RESPONSE_ACCEPT)
	{
		gtk_widget_destroy(dialog);
		return NS_ERROR_ABORT;
	}
	
	PrintInfo *info;
	info = kz_print_dialog_get_print_info(KZ_PRINT_DIALOG(dialog));

	PRBool ToFile = (info->to_file == TRUE);
	printSettings->SetPrintToFile(ToFile);	
	if (ToFile)
	{
		/* check the existence and the permisson */
		gboolean exist;
		exist = g_file_test(info->filename, G_FILE_TEST_EXISTS);

		if (access(info->filename, W_OK) == EACCES ||
		    access(info->filename, W_OK) == EROFS)
		{
			gtk_widget_destroy(dialog);
			return NS_ERROR_ABORT;
		}
		if (exist) 
		{
			gboolean ret;
			ret = gtkutil_confirm_file_replace(GTK_WINDOW(dialog),
							   info->filename);
			if (!ret)
			{
				gtk_widget_destroy(dialog);
				return NS_ERROR_ABORT;
			}
		}
		printSettings->SetToFileName(NS_ConvertUTF8toUCS2(info->filename).get());
	}
	switch (info->range)
	{
	case KZ_PRINT_RANGE_ALL_PAGES:
		printSettings->SetPrintRange(nsIPrintSettings::kRangeAllPages);
		break;
	case KZ_PRINT_RANGE_SPECIFIED_PAGES:
		printSettings->SetPrintRange(nsIPrintSettings::kRangeSpecifiedPageRange);
		printSettings->SetStartPageRange(info->from_page);
		printSettings->SetEndPageRange(info->to_page);
		break;
	case KZ_PRINT_RANGE_SELECTION:
		printSettings->SetPrintRange(nsIPrintSettings::kRangeSelection);
		break;
	default:
		break;
	}

	printSettings->SetPaperSize(nsIPrintSettings::kPaperSizeNativeData);
	printSettings->SetPaperName(NS_ConvertUTF8toUCS2("A4").get());

	printSettings->SetMarginTop(0.0);
	printSettings->SetMarginLeft(0.0);
	printSettings->SetMarginBottom(0.0);
	printSettings->SetMarginRight(0.0);
	printSettings->SetPrinterName(NS_ConvertUTF8toUCS2("PostScript/default").get());
	printSettings->SetHeaderStrLeft(NS_LITERAL_STRING("").get());
	printSettings->SetHeaderStrCenter(NS_LITERAL_STRING("").get());
	printSettings->SetHeaderStrRight(NS_LITERAL_STRING("").get());
	printSettings->SetFooterStrLeft(NS_LITERAL_STRING("").get());
	printSettings->SetFooterStrCenter(NS_LITERAL_STRING("").get());
	printSettings->SetFooterStrRight(NS_LITERAL_STRING("").get());
	printSettings->SetPrintInColor(PR_TRUE);
	printSettings->SetOrientation(nsIPrintSettings::kPortraitOrientation);
	printSettings->SetPrintBGImages(PR_TRUE);
	printSettings->SetPrintBGColors(PR_TRUE);
	printSettings->SetPrintFrameType(nsIPrintSettings::kFramesAsIs);
	printSettings->SetShowPrintProgress(PR_FALSE);
	printSettings->SetShrinkToFit(PR_TRUE);
	printSettings->SetNumCopies(1);
	printSettings->SetPrintSilent(PR_TRUE);

	gtk_widget_destroy(dialog);

	return NS_OK;
}

NS_IMETHODIMP
KzMozPrintingPromptService::ShowProgress (nsIDOMWindow *parent,
      					  nsIWebBrowserPrint *webBrowserPrint,
					  nsIPrintSettings *printSettings,
					  nsIObserver *openDialogObserver,
					  PRBool isForPrinting,
					  nsIWebProgressListener **webProgressListener,
					  nsIPrintProgressParams **printProgressParams,
					  PRBool *notifyOnOpen)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP
KzMozPrintingPromptService::ShowPageSetup (nsIDOMWindow *parent,
					   nsIPrintSettings *printSettings,
					   nsIObserver *printObserver)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}


NS_IMETHODIMP
KzMozPrintingPromptService::ShowPrinterProperties (nsIDOMWindow *parent,
						   const PRUnichar *printerName,
						   nsIPrintSettings *printSettings)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}


