/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-about-dialog.h"

#include <glib/gi18n.h>

#if 0
static const gchar *authors = 
N_("Takuro Ashie <ashie@homa.ne.jp>\n"
   "Hiroyuki Ikezoe <poincare@ikezoe.net>\n"
   "Junichiro Kita <kita@kitaj.no-ip.com>\n"
   "Hidetaka Iwai <tyuyu@sings.jp>");
#endif

static const gchar *copyright = 
N_("Copyright (C) 2002-2005 Kazehakase Project");

static	GtkWidget *bg_pixmap   = NULL;
static	GtkWidget *logo_pixmap = NULL;
static 	GdkPixbuf *image       = NULL;
static  GdkPixbuf *logo        = NULL;	
static 	int bg_width;
static  int bg_height;
static  int logo_width;
static  int logo_height;

static gboolean
cb_expose_event(GtkWidget *widget, GdkEventExpose *event, gpointer data)
{
	PangoLayout *copyright_layout, *version_layout;
	PangoRectangle link, logical;
	gchar *version;

	/* Draw background image */
	gdk_draw_pixbuf(widget->window,
			widget->style->bg_gc[GTK_WIDGET_STATE(widget)],
			image,
			0, 0,
			0, 0,
			-1,-1, 
			GDK_RGB_DITHER_NORMAL,
			0, 0);
	/* Draw logo at top right */
	gdk_draw_pixbuf(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			logo,
			0, 0,
			bg_width - logo_width, 0,
			-1,-1, 
			GDK_RGB_DITHER_NORMAL,
			0, 0);
	/* Draw version under the logo */
	version = g_strdup_printf ("version %s", VERSION);
	version_layout = gtk_widget_create_pango_layout (widget, 
							 version);
	pango_layout_set_alignment(version_layout, PANGO_ALIGN_RIGHT);
	pango_layout_get_pixel_extents(version_layout, &link, &logical);
	gdk_draw_layout(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			bg_width - logical.width, logo_height,
			version_layout);
	g_free (version);
	g_object_unref(version_layout);

	/* Draw copyright at bottom right */
	copyright_layout = gtk_widget_create_pango_layout (widget, 
							   _(copyright));
	pango_layout_set_alignment(copyright_layout, PANGO_ALIGN_RIGHT);
	pango_layout_set_width(copyright_layout, -1);
	pango_layout_get_pixel_extents(copyright_layout, &link, &logical);
	gdk_draw_layout(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			bg_width - logical.width, bg_height - logical.height,
			copyright_layout);

	g_object_unref(copyright_layout);
	return TRUE;
}


void
kz_about_dialog_new (KzWindow *kz)
{
	GtkWidget *about_dialog;
	GtkWidget *calendar;
	GtkWidget *draw;
	GtkWidget *exp;
	GtkWidget *text;
	GtkWidget *scrolledwin;
	GtkTextIter iter;
	GtkTextBuffer *buffer;

	gchar     *pixmap_name;
	gchar     *logo_name;

	about_dialog = gtk_dialog_new_with_buttons(_("About Kazehakase"),
						   GTK_WINDOW(kz),
						   GTK_DIALOG_DESTROY_WITH_PARENT,
						   GTK_STOCK_OK,
						   GTK_RESPONSE_NONE,
						   NULL);
						   
	gtk_window_set_type_hint (GTK_WINDOW (about_dialog),
				  GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_wmclass (GTK_WINDOW (about_dialog),
				"about_dialog", "Kazehakase");
	gtk_window_set_position (GTK_WINDOW (about_dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_resizable (GTK_WINDOW (about_dialog), FALSE);

	pixmap_name = g_strconcat(KZ_DATADIR, "/icons/kz-logo-bg.png", NULL);
	bg_pixmap = gtk_image_new_from_file(pixmap_name);
	image = gtk_image_get_pixbuf(GTK_IMAGE(bg_pixmap));
	bg_width  = gdk_pixbuf_get_width(image);
	bg_height = gdk_pixbuf_get_height(image);
	g_free(pixmap_name);

	logo_name = g_strconcat(KZ_DATADIR, "/icons/kz-logo.png", NULL);
	logo_pixmap = gtk_image_new_from_file(logo_name);
	logo = gtk_image_get_pixbuf(GTK_IMAGE(logo_pixmap));
	logo_width  = gdk_pixbuf_get_width(logo);
	logo_height = gdk_pixbuf_get_height(logo);
	g_free(logo_name);

	draw = gtk_drawing_area_new();
	gtk_widget_set_size_request(draw, bg_width, bg_height);
	g_signal_connect(draw, "expose_event",
			 G_CALLBACK(cb_expose_event), NULL);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(about_dialog)->vbox), draw, TRUE, TRUE, 0);
	gtk_widget_show(draw);
	
	calendar = gtk_calendar_new();
	gtk_calendar_mark_day(GTK_CALENDAR(calendar), 29);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(about_dialog)->vbox), calendar, TRUE, TRUE, 0);
	gtk_widget_show(calendar);

	/* display license*/
	exp = gtk_expander_new(_("Kazehakase License"));
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(about_dialog)->vbox), exp, TRUE, TRUE, 0);

	scrolledwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin),
			GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolledwin),
			GTK_SHADOW_IN);
	gtk_container_add(GTK_CONTAINER(exp), scrolledwin);

	text = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_WORD);
	gtk_text_view_set_left_margin(GTK_TEXT_VIEW(text), 6);
	gtk_text_view_set_right_margin(GTK_TEXT_VIEW(text), 6);
	gtk_container_add(GTK_CONTAINER(scrolledwin), text);

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);

	gtk_text_buffer_insert(buffer, &iter,
		("This program is free software; you can redistribute it and/or modify "
		  "it under the terms of the GNU General Public License as published by "
		  "the Free Software Foundation; either version 2, or (at your option) "
		  "any later version.\n\n"), -1);

	gtk_text_buffer_insert(buffer, &iter,
		("This program is distributed in the hope that it will be useful, "
		  "but WITHOUT ANY WARRANTY; without even the implied warranty of "
		  "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. "
		  "See the GNU General Public License for more details.\n\n"), -1);

	gtk_text_buffer_insert(buffer, &iter,
		("You should have received a copy of the GNU General Public License "
		  "along with this program; if not, write to the Free Software "
		  "Foundation, Inc., 59 Temple Place - Suite 330, Boston, "
		  "MA 02111-1307, USA."), -1);

	g_signal_connect_swapped (about_dialog, 
				  "response", 
				  G_CALLBACK (gtk_widget_destroy),
				  G_OBJECT (about_dialog));
	gtk_widget_show_all(about_dialog);
}
