module Kz
  begin
    require 'gtk2'
    ENABLE = true
  rescue Exception
    ENABLE = false
    STDERR.puts("Ruby extension disabled: require 'gtk2' failed")
  end

  CLOSE_PROCS = []
  class << self
    def print_warning(message)
      STDERR.puts("** KzRuby WARNING **: #{message}")
    end

    def print_error(err)
      print_warning(err.class)
      STDERR.puts(err.message)
      STDERR.puts(err.backtrace)
    end

    def add_close_proc(pr=Proc.new)
      CLOSE_PROCS << pr
    end

    def invoke_close_procs
      CLOSE_PROCS.each do |pr|
        begin
          pr.call
        rescue Exception
          print_error($!)
        end
      end
    end

    def _close
      invoke_close_procs
    end

    def close
      _close
    rescue Exception
      print_error($!)
    end
  end
end
