require 'nkf'
def act_text_link(action, group, kz)
  statusbar_timeout = 3 * 1000
  statusbar_id = kz.statusbar.get_context_id(action.name)
  uri = kz.current_page.selection_string
  normalized_uri = NKF.nkf("-m0 -Z -Z1 -W -w", uri).gsub(/\s/, '')
  matched = false
  case normalized_uri
  when /^https?:/
    matched = true
  when /^t?tps?:/
    normalized_uri = normalized_uri.sub(/^[^:]+(s?)/, "http\\1")
    matched = true
  else
    kz.statusbar.pop(statusbar_id)
    kz.statusbar.push(statusbar_id, _("couldn't open %s as URI") % uri)
    Kz.pop_statusbar(kz, statusbar_id, statusbar_timeout)
  end

  if matched
    kz.statusbar.pop(statusbar_id)
    new_tab = Kz::Conf["Global", "entry_open_in_new_tab", Kz::Conf::BOOL]
    if new_tab
      kz.open_new_tab(normalized_uri)
    else
      kz.load_url(normalized_uri)
    end
  end
end
def act_text_link_config(config, kz)
  config[:label] = N_("Text Link")
  config[:tooltip] = N_("open selected text as URI")
end
