/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __KZ_THUMBNAILS_VIEW_H__
#define __KZ_THUMBNAILS_VIEW_H__

#include <gtk/gtk.h>
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_THUMBNAILS_VIEW			(kz_thumbnails_view_get_type ())
#define KZ_THUMBNAILS_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_THUMBNAILS_VIEW, KzThumbnailsView))
#define KZ_THUMBNAILS_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_THUMBNAILS_VIEW, KzThumbnailsViewClass))
#define KZ_IS_THUMBNAILS_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_THUMBNAILS_VIEW))
#define KZ_IS_THUMBNAILS_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_THUMBNAILS_VIEW))
#define KZ_THUMBNAILS_VIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_THUMBNAILS_VIEW, KzThumbnailsViewClass))

typedef struct _KzThumbnailsView	KzThumbnailsView;
typedef struct _KzThumbnailsViewClass	KzThumbnailsViewClass;

typedef enum 
{
	KZ_THUMBNAILS_VIEW_HORIZONTAL,
	KZ_THUMBNAILS_VIEW_VERTICAL,
	KZ_THUMBNAILS_VIEW_PLANE
}
KzThumbnailsViewMode;

struct _KzThumbnailsView
{
	GtkTable parent;
};

struct _KzThumbnailsViewClass
{
	GtkTableClass parent_class;

	/* signals */
	void (*activate)   (KzThumbnailsView *view, 
			    KzBookmark *bookmark, 
			    gint index); 
};

GType         kz_thumbnails_view_get_type        (void) G_GNUC_CONST;
GtkWidget    *kz_thumbnails_view_new             (void);
void          kz_thumbnails_view_set_folder      (KzThumbnailsView *view,
						  KzBookmark       *folder);
void	      kz_thumbnails_view_set_mode	 (KzThumbnailsView *view,
						  KzThumbnailsViewMode mode);
G_END_DECLS

#endif /* __KZ_THUMBNAILS_VIEW_H__ */
