#include "src/bookmarks/kz-bookmark.h"

#include <gcutter.h>

static KzBookmark *bookmark;

void test_new_with_attrs (void);
void test_title (void);
void test_id (void);
void test_description (void);
void test_last_modified (void);
void test_added_time (void);
void test_last_visited (void);

void
setup (void)
{
    bookmark = NULL;
}

void
teardown (void)
{
    if (bookmark)
        g_object_unref(bookmark);
}

void
test_new_with_attrs (void)
{
    bookmark = kz_bookmark_new_with_attrs("Title",
                                          "URI",
                                          "Description");
    cut_assert(bookmark);
    cut_assert_equal_string("Title", kz_bookmark_get_title(bookmark));
    cut_assert_equal_string("URI", kz_bookmark_get_link(bookmark));
    cut_assert_equal_string("Description", kz_bookmark_get_description(bookmark));
}

void
test_title (void)
{
    cut_trace(test_new_with_attrs());
    kz_bookmark_set_title(bookmark, "title");
    cut_assert_equal_string("title", kz_bookmark_get_title(bookmark));
}

void
test_id (void)
{
    cut_trace(test_new_with_attrs());
    cut_assert_null(kz_bookmark_get_id(bookmark));
    kz_bookmark_set_id(bookmark, "12345");
    cut_assert_equal_string("12345", kz_bookmark_get_id(bookmark));
}

void
test_description (void)
{
    cut_trace(test_new_with_attrs());
    kz_bookmark_set_description(bookmark, "description");
    cut_assert_equal_string("description", kz_bookmark_get_description(bookmark));
}

void
test_last_modified (void)
{
    cut_trace(test_new_with_attrs());
    cut_assert_equal_uint(0, kz_bookmark_get_last_modified(bookmark));
    kz_bookmark_set_last_modified(bookmark, 12345);
    cut_assert_equal_uint(12345, kz_bookmark_get_last_modified(bookmark));
}

void
test_last_visited (void)
{
    cut_trace(test_new_with_attrs());
    cut_assert_equal_uint(0, kz_bookmark_get_last_visited(bookmark));
    kz_bookmark_set_last_visited(bookmark, 12345);
    cut_assert_equal_uint(12345, kz_bookmark_get_last_visited(bookmark));
}

void
test_added_time (void)
{
    cut_trace(test_new_with_attrs());
    cut_assert_equal_uint(0, kz_bookmark_get_added_time(bookmark));
    kz_bookmark_set_added_time(bookmark, 12345);
    cut_assert_equal_uint(12345, kz_bookmark_get_added_time(bookmark));
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
