/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <gtkmozembed.h>

#if 0
#include <libxml/parser.h>
#include <libxml/HTMLparser.h>
#include <libxml/xpath.h>
#include <libxml/nanohttp.h>
#endif

#include "mozilla.h"
#include "config.h"
#include "google.h"
#include "gtk-utils.h"
#include "utils.h"
#include "kz-icons.h"

#define GOOGLE_URI "http://www.google.com/search?lr=lang_ja&hl=ja&ie=UTF-8&oe=utf8&q=%s"

#if 0
static void google_parse_title (xmlDocPtr doc, xmlNodePtr cur);
static void google_parse_site  (xmlDocPtr doc, xmlNodePtr cur);
static void google_parse_body  (xmlDocPtr doc, xmlNodePtr cur);
static void google_parse_result(SearchResult *result);
static void google_result_fetch(SearchResult *result);
#endif

static gchar* google_url_encode(const gchar* utf8src);

/* callbacks */
static void     google_entry_activate_cb (GtkEntry *widget, Google *google);
static gboolean google_icon_press_cb     (GtkWidget *widget, GdkEvent *event,
					  SearchResult *r);

static void
cb_google_destroy (GtkWidget *hbox, Google *google)
{
	g_free(google);
}


/* create new google search item */
GtkWidget *
google_new (KzWindow *kz)
{
	GtkWidget *hbox, *pixmap, *button;
	
	Google *google =NULL;
	google = g_new0(Google, 1);
	google->kz = kz;

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	g_signal_connect(G_OBJECT(hbox), "destroy",
			 G_CALLBACK(cb_google_destroy), google);
	
	/* create google icon button */
	button = gtk_button_new();
	google->Icon = button;
	gtk_button_set_relief((GtkButton *) button, GTK_RELIEF_NONE);
	pixmap = gtk_image_new_from_stock(KZ_STOCK_GOOGLE,
					  GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_container_add(GTK_CONTAINER(button), pixmap);

	/* create the keyword entry */
	google->KeywordEntry = gtk_combo_new();
	gtk_combo_disable_activate(GTK_COMBO(google->KeywordEntry));
	gtk_widget_set_size_request(google->KeywordEntry, 100, -1);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), google->KeywordEntry, TRUE, TRUE, 0);
	
	g_signal_connect(G_OBJECT(GTK_COMBO(google->KeywordEntry)->entry), 
			 "activate",
			 G_CALLBACK(google_entry_activate_cb), google);
	g_signal_connect(G_OBJECT(google->Icon), 
			 "button_press_event",
			 G_CALLBACK(google_icon_press_cb), google);
	make_dir("google");
	
	gtk_widget_show_all(hbox);
	
	return hbox;
}

#if 0
static void
google_parse_title(xmlDocPtr doc, xmlNodePtr cur)
{
	xmlChar *key, *uri;
	cur = cur->xmlChildrenNode;
	while (cur != NULL)
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar*) "a")))
		{
			key = xmlNodeGetContent(cur);
			uri = xmlGetProp(cur, "href");
			g_warning("%s %s\n", key, uri);
			xmlFree(key);
			xmlFree(uri);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar*) "font")))
		{
			key = xmlNodeGetContent(cur);
			g_warning("%s \n", key);
			xmlFree(key);
		}
		cur = cur->next;
	}
	return;
}

static void
google_parse_site(xmlDocPtr doc, xmlNodePtr cur)
{
	xmlChar *key;
	cur = cur->xmlChildrenNode;
	while (cur != NULL)
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar*) "p")))
		{
			if ((!xmlStrcmp(cur->xmlChildrenNode->name, (const xmlChar*) "comment")))
			{
				google_parse_title(doc, cur);
			}
		}
		cur = cur->next;
	}
	return;
}

static void
google_parse_body(xmlDocPtr doc, xmlNodePtr cur)
{
	cur = cur->xmlChildrenNode;
	while (cur != NULL)
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar*) "div")))
		{
			google_parse_site(doc, cur);
			break;
		}
		cur = cur->next;
	}
}

static void 
google_parse_result(SearchResult *result)
{
	htmlDocPtr doc;
	xmlNodePtr cur;
	
	doc = htmlParseFile(result->localfile,"UTF-8");
	
	xmlSubstituteEntitiesDefault(1);

	cur = xmlDocGetRootElement(doc);
	if (!cur) return;

	cur = cur->xmlChildrenNode;
	while (cur != NULL) 
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar*) "body")))
			google_parse_body(doc, cur);
		cur = cur->next;
	}
}
#endif

static gboolean
google_icon_press_cb(GtkWidget *widget, GdkEvent *event,
		     SearchResult *r)
{
#if 0	
	GdkEventButton *event_button;
	if (event->type == GDK_BUTTON_PRESS) {
		event_button = (GdkEventButton *)event;
		if (event_button->button == 1) {
			gtk_menu_popup(GTK_MENU(r->ResultMenu), NULL, NULL,
				       menu_position_under_widget,
				       widget,
				       event_button->button, event_button->time);
			return TRUE;
		}
	}
#endif

	return FALSE;
}

static void
google_entry_activate_cb (GtkEntry *widget, Google *google)
{
	const gchar *text= gtk_entry_get_text(widget);
	gchar *text_encoded;
	gchar *search_uri;

	text_encoded = google_url_encode(text);
	search_uri = g_strdup_printf(GOOGLE_URI, text_encoded);

	kz_window_open_new_tab(google->kz, search_uri);
	g_free(search_uri);
	g_free(text_encoded);
	
#if 0	
	SearchResult *result =NULL;
	result = g_new0(SearchResult, 1);
	
	result->keyword = g_strdup(text);
	result->localfile = g_strdup_printf("%s/.%s/google/%s",g_get_home_dir(),  PACKAGE, text);
	result->uri = g_strdup_printf(GOOGLE_URI, result->keyword);
	google_result_fetch(result);
	google_parse_result(result);
#endif
}

#if 0
static void
google_result_fetch(SearchResult *result)
{
	gchar *contentType;
	if (prefs.proxy)
		xmlNanoHTTPScanProxy(prefs.proxy);
	if (g_file_test(result->localfile, G_FILE_TEST_EXISTS))
		remove (result->localfile);
	xmlNanoHTTPFetch(result->uri, result->localfile, &contentType);	
}
#endif

/* return hex-encoded UTF-8 data
 * please free returned gchar* if unnecessary
 */
static gchar*
google_url_encode(const gchar* utf8src)
{
	GString *dest;
	gchar *ch = utf8src;
	unsigned char buf;

	dest = g_string_sized_new(strlen(utf8src));

	while(*ch != '\0')
	{
		if (((*ch >= 'A') && (*ch <= 'Z')) ||
		    ((*ch >= 'a') && (*ch <= 'z')) ||
		    ((*ch >= '0') && (*ch <= '9')))
		{
			g_string_append_c(dest, *ch);
		}
		else if (*ch == ' ')
		{
			g_string_append_c(dest, '+');

		}
		else
		{
			g_string_append_c(dest, '%');
			buf = (*ch >> 4) & 0x0f;
			g_string_append_c(dest,
					( (buf < 10) ? buf + '0' : buf + ('A' - 10)) );
			buf = *ch & 0x0f;
			g_string_append_c(dest,
					( (buf < 10) ? buf + '0' : buf + ('A' - 10)) );
		}
		ch++;
	}
	
	/* Free gstring and reserve its data.*/
	return g_string_free(dest, FALSE);
}
