/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "gtkmozembed.h"

#include "kazehakase-type.h"
#include "kazehakase.h"

#include "mozilla.h"

void load_finished_cb (GtkMozEmbed *embed, KazehakaseEmbed *kzembed)
{
	Kazehakase *kz = kzembed->parent_kazehakase;
	kzembed->is_loading = 0;
	gtk_widget_set_sensitive(kz->stopButton, FALSE);
	gtk_widget_set_sensitive(kz->reloadButton, TRUE);
	gtk_widget_grab_focus(GTK_WIDGET(embed));
}

void load_started_cb (GtkMozEmbed *embed, KazehakaseEmbed *kzembed)
{
	Kazehakase *kz = kzembed->parent_kazehakase;
	kzembed->is_loading = 1;
	gtk_widget_set_sensitive(kz->stopButton, TRUE);
	gtk_widget_set_sensitive(kz->reloadButton, FALSE);
}

void new_window_orphan_cb (GtkMozEmbedSingle *embed, GtkMozEmbed **retval,
			   guint chromemask, gpointer data)
{
	GtkWidget *newBrowser = gtk_moz_embed_new();
	*retval = GTK_MOZ_EMBED(newBrowser);
}

void visibility_cb (GtkMozEmbed *embed, gboolean visibility,
		    KazehakaseEmbed *kzembed)
{
	set_browser_visibility(kzembed->parent_kazehakase, visibility);
}

void title_changed_cb (GtkMozEmbed *embed, KazehakaseEmbed *kzembed)
{
	Kazehakase *kz = kzembed->parent_kazehakase;
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	
	if (kzembed->title) g_free(kzembed->title);
	kzembed->title = mozilla_get_title(embed);
	if (kzembed->title)
	{
		if (embed == GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook), n)))
		  gtk_window_set_title(GTK_WINDOW(kz->topLevelWindow), kzembed->title);
		gtk_label_set_text(GTK_LABEL(kzembed->notebook_label),
				   kzembed->title);
	}
}

void location_changed_cb (GtkMozEmbed *embed, KazehakaseEmbed *kzembed)
{
	char *newLocation;
	Kazehakase *kz = kzembed->parent_kazehakase;
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));

	newLocation = gtk_moz_embed_get_location(embed);
	if (newLocation)
	{
		if (embed == GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook), n)))
		  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(kz->urlEntry)->entry), newLocation);
		g_free(newLocation);
	}
	else
	  g_print("failed to get location!\n");
	// always make sure to clear the tempMessage.  it might have been
	// set from the link before a click and we wouldn't have gotten the
	// callback to unset it.
/*	update_temp_message(kz, 0); */
	/* update the nav buttons on a location change */
	update_nav_buttons(kz, kzembed->mozembed);
}

void
link_message_cb      (GtkMozEmbed *embed, KazehakaseEmbed *kzembed)
{
	gchar *newMessage;
	Kazehakase *kz = kzembed->parent_kazehakase;

	newMessage = mozilla_get_link_message(embed);
	gtk_statusbar_push(GTK_STATUSBAR(kz->statusBar), 1, newMessage);
/*		gint x,y;
		GtkWidget *newWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);

		gtk_window_set_transient_for(GTK_WINDOW(newWindow), GTK_WINDOW(kz->topLevelWindow));
		GtkMozEmbed *newEmbed = GTK_MOZ_EMBED(gtk_moz_embed_new());
	gtk_moz_embed_load_url(GTK_MOZ_EMBED(newEmbed), newMessage);
//		gtk_moz_embed_set_chrome_mask(newEmbed, chromemask);
		g_signal_connect(G_OBJECT(newEmbed),"destroy_browser",
				 G_CALLBACK(destroy_browser_cb),newWindow);
		gtk_container_add(GTK_CONTAINER(newWindow),GTK_WIDGET(newEmbed));

		gtk_widget_get_size_request(GTK_WIDGET(newEmbed), &x, &y);
		gtk_window_set_default_size(GTK_WINDOW(newWindow), 400, 400);
		gtk_widget_show_all(newWindow);
*/	
	g_free(newMessage);
}

gint 
dom_mouse_click_cb   (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	gint button;
	guint32 time;
	
	Kazehakase *kz = kzembed->parent_kazehakase;

	time = GDK_CURRENT_TIME;
	
     	glong type;
     	MouseEventInfo info;
     	type = mozilla_get_mouse_event_info(embed, event, &info);
	button = mozilla_get_button(event);

	switch ( button ) {
	 case 1:
		if ((type & CONTEXT_LINK) && info.cinfo.link)
		  kazehakase_tab_new(kz,info.cinfo.link);
		break;
	}

	return FALSE;
}

gint
dom_mouse_dbl_click_cb   (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	gint button;
	Kazehakase *kz = kzembed->parent_kazehakase;
	
	button = mozilla_get_button(event);
	switch ( button ) {
	 case 0:
		gtk_notebook_prev_page(GTK_NOTEBOOK(kz->notebook));
		break;
	 case 2:	
		gtk_notebook_next_page(GTK_NOTEBOOK(kz->notebook));
		break;
	}

	return FALSE;
}

gint
dom_mouse_down_cb    (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	gint button;
	glong x,y;
	
	button = mozilla_get_button(event);
	if (button == 2) 
	{
		kzembed->gesture = 1;
		mozilla_get_mouse_position(event, &x, &y);
		kzembed->x = x;
		kzembed->y = y;
	}
	
	return FALSE;
}

gint
dom_mouse_up_cb    (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	glong x,y;
	
	if (kzembed->gesture == 1)
	{
		mozilla_get_mouse_position(event, &x, &y);
		
		if (abs(kzembed->y - y) < abs(kzembed->x - x))
		{
			if (kzembed->x > x)
			  gtk_moz_embed_go_back(GTK_MOZ_EMBED(kzembed->mozembed));
			if (kzembed->x < x)
			  gtk_moz_embed_go_forward(GTK_MOZ_EMBED(kzembed->mozembed));
		}
		else
		{
			if (kzembed->y > y)
			  gtk_moz_embed_reload(GTK_MOZ_EMBED(kzembed->mozembed),
			     GTK_MOZ_EMBED_FLAG_RELOADNORMAL);
			if (kzembed->y < y)
			  kazehakase_tab_close((KazehakaseEmbed *)kzembed);
		}
	}
	kzembed->gesture = 0;
	return FALSE;
}

gint
dom_key_down_cb    (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	gulong key_code;
	
/*	mozilla_get_key_code(event, &key_code);*/
/*	printf("down key=%d\n",key_code);*/

	return FALSE;
}

gint
dom_key_up_cb    (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	gulong key_code;
	
	Kazehakase *kz = kzembed->parent_kazehakase;

	mozilla_get_key_code(event, &key_code);
	
     	glong type;
	KeyEventInfo info;
     	type = mozilla_get_key_event_info(embed, event,&info);

	if ((key_code == 191) && !(type & CONTEXT_INPUT))/* '/' */
	{
		gtk_widget_grab_focus(kz->findArea);
	}
	
	return FALSE;
}

gint
dom_key_press_cb    (GtkMozEmbed *embed, gpointer event, KazehakaseEmbed *kzembed)
{
	gulong char_code;
	
/*	mozilla_get_char_code(event, &char_code); */
/*	printf("press key=%d\n",char_code); */

	return FALSE;
}

void
new_window_cb (GtkMozEmbed *embed, GtkMozEmbed **newEmbed, guint chromemask, KazehakaseEmbed *kzembed)
{
	Kazehakase *kz = kzembed->parent_kazehakase;
	
	if ((chromemask & GTK_MOZ_EMBED_FLAG_OPENASCHROME) != 0)
	{
		/* FIX ME! this is ad hoc. */
		GtkWidget *newWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);

		gtk_window_set_transient_for(GTK_WINDOW(newWindow), GTK_WINDOW(kz->topLevelWindow));
		*newEmbed = GTK_MOZ_EMBED(gtk_moz_embed_new());
		gtk_widget_ref(GTK_WIDGET(newEmbed));
		gtk_object_set_data_full(GTK_OBJECT(newEmbed), "Embed",
					 GTK_WIDGET(newEmbed), 
					 (GtkDestroyNotify)gtk_widget_unref);
		gtk_moz_embed_set_chrome_mask(*newEmbed, chromemask);
		g_signal_connect(G_OBJECT(*newEmbed),"destroy_browser",
				 G_CALLBACK(destroy_browser_cb),newWindow);
		g_signal_connect(G_OBJECT(*newEmbed),"size_to",
				 G_CALLBACK(size_to_cb),NULL);
		gtk_container_add(GTK_CONTAINER(newWindow),GTK_WIDGET(*newEmbed));

		/* gtk_window_set_default_size(GTK_WINDOW(newWindow), x, y); */
		gtk_widget_show_all(newWindow);
	}
	else
	  *newEmbed = GTK_MOZ_EMBED(kazehakase_tab_new(kz, NULL)->mozembed);
}

void 
destroy_browser_cb   (GtkMozEmbed *embed, GtkWidget *transient_window)
{
	gtk_widget_destroy(GTK_WIDGET(transient_window));
}
/*
void 
destroy_cb (GtkMozEmbed *embed, KazehakaseEmbed *kzembed)
{
	gtk_main_quit();
}
*/
gint open_uri_cb (GtkMozEmbed *embed, const char *uri, KazehakaseEmbed *kzembed)
{
	if (!strncmp(uri, "mailto:",7))
	  return TRUE;

	return FALSE;
}

void
size_to_cb (GtkMozEmbed *embed, gint width, gint height,KazehakaseEmbed *kzembed)
{
	gtk_widget_set_usize(GTK_WIDGET(embed), width, height);
}

