/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "rd-window.h"
#include "rendako.h"

#include "rd-open-search.h"
#include "rd-snail-view.h"
#include "rd-site-cord.h"

#include <glib/gi18n.h>

#define RD_WINDOW_WIDTH 800

typedef struct _RdWindowPrivate RdWindowPrivate;
struct _RdWindowPrivate
{
	GtkWidget *main_vbox;
	RdOpenSearch *os;
	RdSnailView *sv;
	RdSiteCord *sc;
};

#define RD_WINDOW_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), RD_TYPE_WINDOW, RdWindowPrivate))

static void     rd_window_class_init     (RdWindowClass *klass);
static void     rd_window_init           (RdWindow      *window);
static void     rd_window_dispose        (GObject         *object);
static void     rd_window_destroy        (GtkObject       *object);
static void     rd_window_finalize       (GObject         *object);
#if 0
static void cb_add_widget (GtkUIManager *manager, GtkWidget *widget,
	    		   RdWindow *window);
#endif
static void cb_open_search_link (RdOpenSearch *os, const gchar *uri, gpointer data);

static GtkWindowClass *parent_class = NULL;

G_DEFINE_TYPE (RdWindow, rd_window, GTK_TYPE_WINDOW)

static void
rd_window_class_init (RdWindowClass *klass)
{
	GObjectClass *gobject_class;
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	parent_class = g_type_class_peek_parent (klass);

	gobject_class = (GObjectClass *)   klass;
	object_class  = (GtkObjectClass *) klass;
	widget_class  = (GtkWidgetClass *) klass;
  
	gobject_class->dispose = rd_window_dispose;
	gobject_class->finalize = rd_window_finalize;

	object_class->destroy = rd_window_destroy;
	g_type_class_add_private (gobject_class, sizeof(RdWindowPrivate));
}

static void
rd_window_init (RdWindow *window)
{
	GtkWidget *snail_view;
	GtkTreeModel *model;
	RdWindowPrivate *priv = RD_WINDOW_GET_PRIVATE (window);

	priv->main_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (priv->main_vbox);
	gtk_container_add (GTK_CONTAINER (window),
			   priv->main_vbox);

	priv->sc = rd_site_cord_new ();
	model = GTK_TREE_MODEL (rd_site_cord_get_list_store (priv->sc));

	snail_view = rd_snail_view_new_with_model (model);
	rd_snail_view_set_image_column (RD_SNAIL_VIEW (snail_view), 2);

	gtk_widget_show (snail_view);
	gtk_box_pack_start (GTK_BOX (priv->main_vbox), snail_view,
			    TRUE, TRUE, 0);
	priv->sv = RD_SNAIL_VIEW (snail_view);

	gtk_window_set_default_size (GTK_WINDOW (window), RD_WINDOW_WIDTH, 600);

	priv->os = rd_open_search_new ();
	g_signal_connect (priv->os, "link",
			  G_CALLBACK (cb_open_search_link), window);
}

static void
rd_window_destroy (GtkObject *object)
{
	GTK_OBJECT_CLASS (parent_class)->destroy (object);

	gtk_main_quit();
}

static void
rd_window_dispose (GObject *object)
{
	RdWindowPrivate *priv = RD_WINDOW_GET_PRIVATE (object);

	if (priv->os)
	{
		g_signal_handlers_disconnect_by_func (priv->os,
						      G_CALLBACK (cb_open_search_link),
						      object);
		g_object_unref (priv->os);
		priv->os = NULL;
	}

	if (G_OBJECT_CLASS (parent_class)->dispose)
		G_OBJECT_CLASS (parent_class)->dispose (object);
}

static void
rd_window_finalize (GObject *object)
{
	if (G_OBJECT_CLASS (parent_class)->finalize)
		G_OBJECT_CLASS (parent_class)->finalize (object);
}

GtkWidget *
rd_window_new (void)
{
	RdWindow *window;

	window = g_object_new (RD_TYPE_WINDOW, NULL);

	return GTK_WIDGET (window);
}

#if 0
static void
cb_add_widget (GtkUIManager *manager,
	       GtkWidget *widget,
	       RdWindow *window)
{
	RdWindowPrivate *priv = RD_WINDOW_GET_PRIVATE (window);
	gtk_box_pack_start (GTK_BOX (priv->menu_dock),
			    widget, FALSE, FALSE, 0);
}
#endif

static void
cb_open_search_link (RdOpenSearch *os, const gchar *uri, gpointer data)
{
	RdWindowPrivate *priv = RD_WINDOW_GET_PRIVATE (data);

	rd_site_cord_append_uri (priv->sc, uri);
}

void
rd_window_load_uri(RdWindow *window, const gchar *uri)
{
	RdWindowPrivate *priv = RD_WINDOW_GET_PRIVATE (window);

	rd_open_search_keyword (priv->os, uri);
}

