#include "GeckoProgress.h"

NS_IMPL_ISUPPORTS2(GeckoProgress, nsIWebProgressListener,
		   	          nsISupportsWeakReference)

GeckoProgress::GeckoProgress ()
{
}

GeckoProgress::~GeckoProgress ()
{
}

NS_IMETHODIMP
GeckoProgress::Init (GeckoThumbnailer *thumbnailer)
{
	mThumbnailer = thumbnailer;
}


/* void onStateChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aStateFlags, in nsresult aStatus); */
NS_IMETHODIMP
GeckoProgress::OnStateChange (nsIWebProgress *aWebProgress, nsIRequest *aRequest, PRUint32 aStateFlags, nsresult aStatus)
{
	if ((aStateFlags & STATE_IS_NETWORK) && (aStateFlags & STATE_STOP))
		mThumbnailer->CreateThumbnail ();

	return NS_OK;
}

/* void onProgressChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in long aCurSelfProgress, in long aMaxSelfProgress, in long aCurTotalProgress, in long aMaxTotalProgress); */
NS_IMETHODIMP
GeckoProgress::OnProgressChange (nsIWebProgress *aWebProgress, nsIRequest *aRequest, 
			      PRInt32 aCurSelfProgress, PRInt32 aMaxSelfProgress,
			      PRInt32 aCurTotalProgress, PRInt32 aMaxTotalProgress)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onLocationChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in nsIURI aLocation); */
NS_IMETHODIMP
GeckoProgress::OnLocationChange (nsIWebProgress *aWebProgress, nsIRequest *aRequest, nsIURI *aLocation)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onStatusChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in nsresult aStatus, in wstring aMessage); */
NS_IMETHODIMP
GeckoProgress::OnStatusChange (nsIWebProgress *aWebProgress, nsIRequest *aRequest, nsresult aStatus, const PRUnichar *aMessage)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onSecurityChange (in nsIWebProgress aWebProgress, in nsIRequest aRequest, in unsigned long aState); */
NS_IMETHODIMP
GeckoProgress::OnSecurityChange (nsIWebProgress *aWebProgress, nsIRequest *aRequest, PRUint32 aState)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}
