/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_THUMBNAILER_H__
#define __RD_THUMBNAILER_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define RD_TYPE_THUMBNAILER		(rd_thumbnailer_get_type ())
#define RD_THUMBNAILER(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_THUMBNAILER, RdThumbnailer))
#define RD_THUMBNAILER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  RD_TYPE_THUMBNAILER, RdThumbnailerClass))
#define RD_IS_THUMBNAILER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_THUMBNAILER))
#define RD_IS_THUMBNAILER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  RD_TYPE_THUMBNAILER))
#define RD_THUMBNAILER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  RD_TYPE_THUMBNAILER, RdThumbnailerClass))

typedef struct _RdThumbnailer		RdThumbnailer;
typedef struct _RdThumbnailerClass	RdThumbnailerClass;

struct _RdThumbnailer
{
	GObject parent;
};

struct _RdThumbnailerClass
{
	GObjectClass parent_class;
	
	/* signals */
	void (*ready)         (RdThumbnailer *thumbnailer,
			       gpointer image_data,
			       const gchar *uri);
};

GType		 rd_thumbnailer_get_type  (void);

RdThumbnailer	*rd_thumbnailer_new       (void);

gboolean	 rd_thumbnailer_is_creating (RdThumbnailer *thumbnailer);
void		 rd_thumbnailer_request_uri (RdThumbnailer *thumbnailer, const gchar *uri);

G_END_DECLS

#endif /* __RD_THUMBNAILER_H__ */
