/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_SITE_CORD_H__
#define __RD_SITE_CORD_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define RD_TYPE_SITE_CORD            (rd_site_cord_get_type ())
#define RD_SITE_CORD(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_SITE_CORD, RdSiteCord))
#define RD_SITE_CORD_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RD_TYPE_SITE_CORD, RdSiteCordClass))
#define RD_IS_SITE_CORD(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_SITE_CORD))
#define RD_IS_SITE_CORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RD_TYPE_SITE_CORD))
#define RD_SITE_CORD_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RD_TYPE_SITE_CORD, RdSiteCordClass))

enum
{
	COLUMN_URI,
	COLUMN_DESCRIPTION,
	COLUMN_IMAGE,
	N_COLUMNS
};

typedef struct _RdSiteCord	RdSiteCord;
typedef struct _RdSiteCordClass	RdSiteCordClass;

struct _RdSiteCord
{
	GObject  parent;
};

struct _RdSiteCordClass
{
	GObjectClass parent_class;
};

GType	            rd_site_cord_get_type  (void);

RdSiteCord         *rd_site_cord_new       (void);

void		    rd_site_cord_append_uri (RdSiteCord *cord, const gchar *uri);

const GtkListStore *rd_site_cord_get_list_store (RdSiteCord *cord);

G_END_DECLS

#endif /* __RD_SITE_CORD_H__ */
