/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ApplicationListener;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.Stream;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Application
extends SkypeObject {
    private static final ConcurrentMap<String, Application> applications = new ConcurrentHashMap<String, Application>();
    private final String name;
    private boolean isInitialized;
    private final Object isInitializedFieldMutex = new Object();
    private Thread shutdownHookForFinish = new ShutdownHookForFinish();
    private final ConnectorListener dataListener = new DataListener();
    private final Object connectMutex = new Object();
    private final List<ApplicationListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, Stream> streams = new HashMap<String, Stream>();
    private SkypeExceptionHandler exceptionHandler;

    static Application getInstance(String string) throws SkypeException {
        Application application = new Application(string);
        Application application2 = applications.putIfAbsent(string, application);
        if (application2 == null) {
            application2 = application;
        }
        application2.initialize();
        return application2;
    }

    private Application(String string) throws SkypeException {
        assert (string != null);
        this.name = string;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                String string = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
                this.getAllStreams();
                if (string.startsWith("ERROR ") && !string.startsWith("ERROR 541 ")) {
                    Utils.checkError(string);
                }
                if (!this.isInitialized) {
                    Connector.getInstance().addConnectorListener(this.dataListener, false, true);
                    Runtime.getRuntime().addShutdownHook(this.shutdownHookForFinish);
                    this.isInitialized = true;
                }
            }
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                if (this.isInitialized) {
                    Connector.getInstance().removeConnectorListener(this.dataListener);
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookForFinish);
                    String string = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
                    Utils.checkError(string);
                    this.isInitialized = false;
                }
            }
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public Stream[] connectToAll() throws SkypeException {
        return this.connect(this.getAllConnectableFriends());
    }

    public Stream[] connect(Friend ... friendArray) throws SkypeException {
        Utils.checkNotNull("friends", friendArray);
        return this.connect(this.toIds(friendArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream[] connect(final String ... stringArray) throws SkypeException {
        Utils.checkNotNull("ids", stringArray);
        Object object = this.connectMutex;
        synchronized (object) {
            try {
                final Stream[] streamArray = new Object();
                AbstractConnectorListener abstractConnectorListener = new AbstractConnectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.equals("APPLICATION " + Application.this.getName() + " CONNECTING ")) {
                            Object object = streamArray;
                            synchronized (object) {
                                streamArray.notify();
                            }
                        } else if (string.startsWith("APPLICATION " + Application.this.getName() + " STREAMS ")) {
                            String string2 = string.substring(("APPLICATION " + Application.this.getName() + " STREAMS ").length());
                            if ("".equals(string2)) {
                                return;
                            }
                            for (String string3 : string2.split(" ")) {
                                for (String string4 : stringArray) {
                                    if (!string3.startsWith(string4 + ":")) continue;
                                    Object object = streamArray;
                                    synchronized (object) {
                                        streamArray.notify();
                                        return;
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(abstractConnectorListener);
                    Stream[] streamArray2 = streamArray;
                    synchronized (streamArray) {
                        for (String string : stringArray) {
                            if (string == null) continue;
                            String string2 = "ALTER APPLICATION " + this.getName() + " CONNECT " + string;
                            String string3 = Connector.getInstance().execute(string2, new String[]{string2, "APPLICATION " + this.getName() + " CONNECTING ", "ERROR "});
                            Utils.checkError(string3);
                        }
                        try {
                            streamArray.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new SkypeException("The connecting was interrupted.", interruptedException);
                        }
                        streamArray2 = this.getAllStreams(stringArray);
                        return streamArray2;
                    }
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                    Stream[] streamArray3 = null;
                    return streamArray3;
                }
                finally {
                    Connector.getInstance().removeConnectorListener(abstractConnectorListener);
                }
            }
            catch (SkypeException skypeException) {
                Stream[] streamArray = this.getAllStreams(stringArray);
                int n = streamArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        throw skypeException;
                    }
                    Stream stream = streamArray[n2];
                    try {
                        stream.disconnect();
                    }
                    catch (SkypeException skypeException2) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }

    public Stream[] getAllStreams(Friend ... friendArray) throws SkypeException {
        Utils.checkNotNull("friends", friendArray);
        return this.getAllStreams(this.toIds(friendArray));
    }

    private String[] toIds(Friend ... friendArray) {
        String[] stringArray = new String[friendArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = friendArray[i].getId();
        }
        return stringArray;
    }

    public Stream[] getAllStreams(String ... stringArray) throws SkypeException {
        ArrayList<Stream> arrayList = new ArrayList<Stream>();
        for (Stream stream : this.getAllStreams()) {
            String string = stream.getFriend().getId();
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                arrayList.add(stream);
            }
        }
        return arrayList.toArray(new Stream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream[] getAllStreams() throws SkypeException {
        String string = Utils.getPropertyWithCommandId("APPLICATION", this.getName(), "STREAMS");
        Map<String, Stream> map = this.streams;
        synchronized (map) {
            this.fireStreamEvents(string);
            if ("".equals(string)) {
                return new Stream[0];
            }
            String[] stringArray = string.split(" ");
            Stream[] streamArray = new Stream[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                streamArray[i] = this.streams.get(stringArray[i]);
            }
            return streamArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamEvents(String string) {
        Map<String, Stream> map = this.streams;
        synchronized (map) {
            String[] stringArray;
            String[] stringArray2 = stringArray = "".equals(string) ? new String[]{} : string.split(" ");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray2[i];
                if (this.streams.containsKey(string2)) continue;
                Stream object = new Stream(this, string2);
                this.streams.put(string2, object);
                this.fireConnected(object);
            }
            block4: for (String string2 : stringArray2 = this.streams.keySet().toArray(new String[0])) {
                for (String string3 : stringArray) {
                    if (string2.equals(string3)) continue block4;
                }
                Stream stream = this.streams.remove(string2);
                this.fireDisconnected(stream);
            }
        }
    }

    private void fireConnected(Stream stream) {
        ApplicationListener[] applicationListenerArray;
        assert (stream != null);
        for (ApplicationListener applicationListener : applicationListenerArray = this.listeners.toArray(new ApplicationListener[0])) {
            try {
                applicationListener.connected(stream);
            }
            catch (Throwable throwable) {
                Utils.handleUncaughtException(throwable, this.exceptionHandler);
            }
        }
    }

    private void fireDisconnected(Stream stream) {
        ApplicationListener[] applicationListenerArray;
        assert (stream != null);
        for (ApplicationListener applicationListener : applicationListenerArray = this.listeners.toArray(new ApplicationListener[0])) {
            try {
                applicationListener.disconnected(stream);
            }
            catch (Throwable throwable) {
                Utils.handleUncaughtException(throwable, this.exceptionHandler);
            }
        }
    }

    public void addApplicationListener(ApplicationListener applicationListener) {
        Utils.checkNotNull("listener", applicationListener);
        this.listeners.add(applicationListener);
    }

    public void removeApplicationListener(ApplicationListener applicationListener) {
        Utils.checkNotNull("listener", applicationListener);
        this.listeners.remove(applicationListener);
    }

    public Friend[] getAllConnectableFriends() throws SkypeException {
        return this.getAllFriends("CONNECTABLE");
    }

    public Friend[] getAllConnectingFriends() throws SkypeException {
        return this.getAllFriends("CONNECTING");
    }

    public Friend[] getAllConnectedFriends() throws SkypeException {
        return this.getAllFriends("STREAMS");
    }

    public Friend[] getAllSendingFriends() throws SkypeException {
        return this.getAllFriends("SENDING");
    }

    public Friend[] getAllReceivedFriends() throws SkypeException {
        return this.getAllFriends("RECEIVED");
    }

    private Friend[] getAllFriends(String string) throws SkypeException {
        try {
            String string2 = "GET APPLICATION " + this.getName() + " " + string;
            String string3 = "APPLICATION " + this.getName() + " " + string + " ";
            String string4 = Connector.getInstance().executeWithId(string2, string3);
            Utils.checkError(string4);
            return this.extractFriends(string4.substring(string3.length()));
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    private Friend[] extractFriends(String string) throws SkypeException {
        Object object;
        assert (string != null);
        if ("".equals(string)) {
            return new Friend[0];
        }
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (!((String)object).contains(":")) continue;
            stringArray[i] = ((String)object).substring(0, ((String)object).indexOf(58));
        }
        Friend[] friendArray = Skype.getContactList().getAllFriends();
        object = new ArrayList();
        for (String string2 : stringArray) {
            for (Friend friend : friendArray) {
                if (!friend.getId().equals(string2)) continue;
                object.add(friend);
            }
        }
        return object.toArray(new Friend[0]);
    }

    private class ShutdownHookForFinish
    extends Thread {
        private ShutdownHookForFinish() {
        }

        public void run() {
            try {
                Connector.getInstance().execute("DELETE APPLICATION " + Application.this.getName());
            }
            catch (ConnectorException connectorException) {
                // empty catch block
            }
        }
    }

    private class DataListener
    extends AbstractConnectorListener {
        private DataListener() {
        }

        public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
            String string;
            String string2;
            String string3 = connectorMessageEvent.getMessage();
            if (string3.startsWith(string2 = "APPLICATION " + Application.this.getName() + " STREAMS ")) {
                string = string3.substring(string2.length());
                Application.this.fireStreamEvents(string);
            }
            if (string3.startsWith(string = "APPLICATION " + Application.this.getName() + " ")) {
                this.handleData(string3.substring(string.length()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleData(String string) {
            block11: {
                try {
                    if (this.isReceivedText(string)) {
                        String string2 = string.substring("RECEIVED ".length());
                        String string3 = string2.substring(0, string2.indexOf(61));
                        String string4 = "ALTER APPLICATION " + Application.this.getName() + " READ " + string3;
                        String string5 = Connector.getInstance().executeWithId(string4, string4);
                        Utils.checkError(string5);
                        String string6 = string5.substring(string4.length() + 1);
                        Map map = Application.this.streams;
                        synchronized (map) {
                            if (Application.this.streams.containsKey(string3)) {
                                ((Stream)Application.this.streams.get(string3)).fireTextReceived(string6);
                            }
                            break block11;
                        }
                    }
                    if (!this.isReceivedDatagram(string)) break block11;
                    String string7 = string.substring("DATAGRAM ".length());
                    String string8 = string7.substring(0, string7.indexOf(32));
                    String string9 = string7.substring(string7.indexOf(32) + 1);
                    Map map = Application.this.streams;
                    synchronized (map) {
                        if (Application.this.streams.containsKey(string8)) {
                            ((Stream)Application.this.streams.get(string8)).fireDatagramReceived(string9);
                        }
                    }
                }
                catch (Exception exception) {
                    Utils.handleUncaughtException(exception, Application.this.exceptionHandler);
                }
            }
        }

        private boolean isReceivedText(String string) {
            return string.startsWith("RECEIVED ") && "RECEIVED ".length() < string.length();
        }

        private boolean isReceivedDatagram(String string) {
            return string.startsWith("DATAGRAM ");
        }
    }
}

