/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.MenuItemClickEvent;
import com.skype.MenuItemListener;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class MenuItem {
    private static final Map<String, MenuItem> menuItems = new ConcurrentHashMap<String, MenuItem>();
    private static final AtomicInteger menuItemNumber = new AtomicInteger();
    private static final Object menuItemListenerMutex = new Object();
    private static ConnectorListener menuItemListener;
    private final String id = "menuItem" + menuItemNumber.getAndIncrement();
    private final Context context;
    private String caption;
    private String hint;
    private final File iconFile;
    private boolean enabled;
    private final String targetSkypeId;
    private final boolean multipleContactsEnabled;
    private final List<MenuItemListener> menuItemListeners = new CopyOnWriteArrayList<MenuItemListener>();

    static MenuItem getInstance(String string) {
        return menuItems.get(string);
    }

    static MenuItem addMenuItem(Context context, String string, String string2, File file, boolean bl, String string3, boolean bl2) {
        MenuItem menuItem = new MenuItem(context, string, string2, file, bl, string3, bl2);
        menuItems.put(menuItem.getId(), menuItem);
        return menuItem;
    }

    MenuItem(Context context, String string, String string2, File file, boolean bl, String string3, boolean bl2) {
        this.context = context;
        this.caption = string;
        this.hint = string2;
        this.iconFile = file;
        this.enabled = bl;
        this.targetSkypeId = string3;
        this.multipleContactsEnabled = bl2;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MenuItem) {
            return this.getId().equals(((MenuItem)object).getId());
        }
        return false;
    }

    String getId() {
        return this.id;
    }

    public Context getContext() {
        return this.context;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String string) throws SkypeException {
        Utils.checkNotNull("caption", string);
        this.caption = string;
        this.setStringProperty("CAPTION", string);
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String string) throws SkypeException {
        this.hint = string;
        if (string == null) {
            string = "";
        }
        this.setStringProperty("HINT", string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) throws SkypeException {
        this.enabled = bl;
        this.setProperty("ENABLED", "" + bl);
    }

    private void setStringProperty(String string, String string2) throws SkypeException {
        this.setProperty(string, "\"" + string2 + "\"");
    }

    private void setProperty(String string, String string2) throws SkypeException {
        Utils.setProperty("MENU_ITEM", this.getId(), string, string2);
    }

    public File getIconFile() {
        return this.iconFile;
    }

    public boolean isMultipleContactsEnabled() {
        return this.multipleContactsEnabled;
    }

    public String getTargetSkypeId() {
        return this.targetSkypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItemListener(MenuItemListener menuItemListener) throws SkypeException {
        Utils.checkNotNull("listener", menuItemListener);
        this.menuItemListeners.add(menuItemListener);
        Object object = menuItemListenerMutex;
        synchronized (object) {
            if (MenuItem.menuItemListener == null) {
                MenuItem.menuItemListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.startsWith("MENU_ITEM ") && string.indexOf(" CLICKED ") != -1) {
                            Context context;
                            String string2 = string.substring("MENU_ITEM ".length());
                            int n = string2.indexOf(" CLICKED ");
                            String string3 = string2.substring(0, n);
                            string2 = string2.substring(n + " CLICKED ".length());
                            int n2 = string2.indexOf("CONTEXT ");
                            String[] stringArray = Utils.convertToArray(string2.substring(0, n2));
                            string2 = string2.substring(n2 + "CONTEXT ".length());
                            int n3 = string2.indexOf(32);
                            String[] stringArray2 = new String[]{};
                            if (n3 == -1) {
                                context = Context.valueOf(string2.toUpperCase());
                            } else {
                                context = Context.valueOf(string2.substring(0, n3));
                                string2 = string2.substring(n3 + 1);
                                stringArray2 = Utils.convertToArray(string2.substring("CONTEXT_ID ".length()));
                            }
                            MenuItem menuItem = MenuItem.getInstance(string3);
                            if (menuItem != null) {
                                MenuItemListener[] menuItemListenerArray;
                                for (MenuItemListener menuItemListener : menuItemListenerArray = menuItem.menuItemListeners.toArray(new MenuItemListener[0])) {
                                    try {
                                        menuItemListener.menuItemClicked(new MenuItemClickEvent(MenuItem.this, stringArray, context, stringArray2));
                                    }
                                    catch (Throwable throwable) {
                                        Skype.handleUncaughtException(throwable);
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(MenuItem.menuItemListener);
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMenuItemListener(MenuItemListener menuItemListener) {
        Utils.checkNotNull("listener", menuItemListener);
        this.menuItemListeners.remove(menuItemListener);
        Object object = menuItemListenerMutex;
        synchronized (object) {
            boolean bl = true;
            for (MenuItem menuItem : menuItems.values()) {
                bl &= menuItem.menuItemListeners.isEmpty();
            }
            if (bl) {
                Connector.getInstance().removeConnectorListener(MenuItem.menuItemListener);
                MenuItem.menuItemListener = null;
            }
        }
    }

    public void dispose() throws SkypeException {
        try {
            String string = "DELETE MENU_ITEM " + this.getId();
            String string2 = Connector.getInstance().execute(string);
            Utils.checkError(string2);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Context {
        CHAT,
        CALL,
        CONTACT,
        MYSELF,
        TOOLS;

    }
}

