/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.Call;
import com.skype.CallListener;
import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.ContactList;
import com.skype.Profile;
import com.skype.SMS;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.User;
import com.skype.Utils;
import com.skype.VoiceMail;
import com.skype.VoiceMailListener;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Skype {
    public static final String LIBRARY_VERSION = "1.0.0.0";
    private static ContactList contactList;
    private static Profile profile;
    private static Object chatMessageListenerMutex;
    private static ConnectorListener chatMessageListener;
    private static List<ChatMessageListener> chatMessageListeners;
    private static Object callListenerMutex;
    private static ConnectorListener callListener;
    private static List<CallListener> callListeners;
    private static Object voiceMailListenerMutex;
    private static ConnectorListener voiceMailListener;
    private static List<VoiceMailListener> voiceMailListeners;
    private static Object userThreadFieldMutex;
    private static Thread userThread;
    private static SkypeExceptionHandler defaultExceptionHandler;
    private static SkypeExceptionHandler exceptionHandler;

    @Deprecated
    public static void setDeamon(boolean bl) {
        Skype.setDaemon(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDaemon(boolean bl) {
        Object object = userThreadFieldMutex;
        synchronized (object) {
            if (!bl && userThread == null) {
                userThread = new Thread("SkypeUserThread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        Object object2 = object = new Object();
                        synchronized (object2) {
                            try {
                                object.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                userThread.start();
            } else if (bl && userThread != null) {
                userThread.interrupt();
                userThread = null;
            }
        }
    }

    public static void setDebug(boolean bl) throws SkypeException {
        try {
            Connector.getInstance().setDebug(bl);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public static String getVersion() throws SkypeException {
        return Utils.getProperty("SKYPEVERSION");
    }

    public static boolean isInstalled() {
        String string = Skype.getInstalledPath();
        if (string == null) {
            return false;
        }
        return new File(string).exists();
    }

    public static String getInstalledPath() {
        return Connector.getInstance().getInstalledPath();
    }

    public static boolean isRunning() throws SkypeException {
        try {
            return Connector.getInstance().isRunning();
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return false;
        }
    }

    public static User[] searchUsers(String string) throws SkypeException {
        String string2;
        String string3 = "SEARCH USERS " + string;
        String string4 = "USERS ";
        try {
            string2 = Connector.getInstance().executeWithId(string3, string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
        Utils.checkError(string2);
        String string5 = string2.substring(string4.length());
        String[] stringArray = Utils.convertToArray(string5);
        User[] userArray = new User[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            userArray[i] = User.getInstance(stringArray[i]);
        }
        return userArray;
    }

    public static ContactList getContactList() throws SkypeException {
        if (contactList == null) {
            contactList = new ContactList();
        }
        return contactList;
    }

    public static Call call(String ... stringArray) throws SkypeException {
        Utils.checkNotNull("skypeIds", stringArray);
        return Skype.call(Utils.convertToCommaSeparatedString(stringArray));
    }

    public static Call call(String string) throws SkypeException {
        Utils.checkNotNull("skypeIds", string);
        try {
            String string2 = "CALL ";
            String string3 = Connector.getInstance().executeWithId("CALL " + string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length(), string3.indexOf(" STATUS "));
            return Call.getInstance(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static Chat chat(String[] stringArray) throws SkypeException {
        Utils.checkNotNull("skypeIds", stringArray);
        return Skype.chat(Utils.convertToCommaSeparatedString(stringArray));
    }

    public static Chat chat(String string) throws SkypeException {
        try {
            String string2 = "CHAT ";
            String string3 = Connector.getInstance().executeWithId("CHAT CREATE " + string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length(), string3.indexOf(" STATUS "));
            return Chat.getInstance(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static SMS submitConfirmationCode(String[] stringArray) throws SkypeException {
        Utils.checkNotNull("numbers", stringArray);
        return Skype.submitConfirmationCode(Utils.convertToCommaSeparatedString(stringArray));
    }

    public static SMS submitConfirmationCode(String string) throws SkypeException {
        SMS sMS = Skype.createSMS(string, SMS.Type.CONFIRMATION_CODE_REQUEST);
        sMS.send();
        return sMS;
    }

    public static SMS submitConfirmationCode(String[] stringArray, String string) throws SkypeException {
        Utils.checkNotNull("numbers", stringArray);
        Utils.checkNotNull("code", string);
        return Skype.submitConfirmationCode(Utils.convertToCommaSeparatedString(stringArray), string);
    }

    public static SMS submitConfirmationCode(String string, String string2) throws SkypeException {
        Utils.checkNotNull("number", string);
        Utils.checkNotNull("code", string2);
        SMS sMS = Skype.createSMS(string, SMS.Type.CONFIRMATION_CODE_REQUEST);
        sMS.setContent(string2);
        sMS.send();
        return sMS;
    }

    public static SMS sendSMS(String[] stringArray, String string) throws SkypeException {
        Utils.checkNotNull("numbers", stringArray);
        return Skype.sendSMS(Utils.convertToCommaSeparatedString(stringArray), string);
    }

    public static SMS sendSMS(String string, String string2) throws SkypeException {
        Utils.checkNotNull("number", string);
        Utils.checkNotNull("content", string2);
        SMS sMS = Skype.createSMS(string, SMS.Type.OUTGOING);
        sMS.setContent(string2);
        sMS.send();
        return sMS;
    }

    private static SMS createSMS(String string, SMS.Type type) throws SkypeException {
        try {
            String string2 = "SMS ";
            String string3 = Connector.getInstance().executeWithId("CREATE SMS " + (Object)((Object)type) + " " + string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length(), string3.indexOf(" STATUS "));
            return SMS.getInstance(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public SMS[] getAllSMSs() throws SkypeException {
        return this.getAllSMSs("SMSS");
    }

    public SMS[] getAllMissedSMSs() throws SkypeException {
        return this.getAllSMSs("MISSEDSMSS");
    }

    private SMS[] getAllSMSs(String string) throws SkypeException {
        try {
            String string2 = "SEARCH " + string;
            String string3 = "SMSS ";
            String string4 = Connector.getInstance().execute(string2, string3);
            String string5 = string4.substring(string3.length());
            String[] stringArray = Utils.convertToArray(string5);
            SMS[] sMSArray = new SMS[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                sMSArray[i] = SMS.getInstance(stringArray[i]);
            }
            return sMSArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static VoiceMail voiceMail(String string) throws SkypeException {
        try {
            String string2 = "VOICEMAIL ";
            String string3 = Connector.getInstance().executeWithId("VOICEMAIL " + string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length(), string3.indexOf(32, string2.length()));
            return VoiceMail.getInstance(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static VoiceMail[] getAllVoiceMails() throws SkypeException {
        try {
            String string = "SEARCH VOICEMAILS";
            String string2 = "VOICEMAILS ";
            String string3 = Connector.getInstance().execute(string, string2);
            String string4 = string3.substring(string2.length());
            String[] stringArray = Utils.convertToArray(string4);
            VoiceMail[] voiceMailArray = new VoiceMail[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                voiceMailArray[i] = VoiceMail.getInstance(stringArray[i]);
            }
            return voiceMailArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static Application addApplication(String string) throws SkypeException {
        Utils.checkNotNull("name", string);
        return Application.getInstance(string);
    }

    public static String getAudioInputDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("AUDIO_IN"));
    }

    public static String getAudioOutputDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("AUDIO_OUT"));
    }

    public static String getVideoDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("VIDEO_IN"));
    }

    private static String convertDefaultDeviceToNull(String string) {
        if (Skype.isDefaultDevice(string)) {
            return null;
        }
        return string;
    }

    private static boolean isDefaultDevice(String string) {
        return "".equals(string);
    }

    public static void setAudioInputDevice(String string) throws SkypeException {
        Utils.setProperty("AUDIO_IN", Skype.convertNullToDefaultDevice(string));
    }

    public static void setAudioOutputDevice(String string) throws SkypeException {
        Utils.setProperty("AUDIO_OUT", Skype.convertNullToDefaultDevice(string));
    }

    public static void setVideoDevice(String string) throws SkypeException {
        Utils.setProperty("VIDEO_IN", Skype.convertNullToDefaultDevice(string));
    }

    private static String convertNullToDefaultDevice(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static synchronized Profile getProfile() {
        if (profile == null) {
            profile = new Profile();
        }
        return profile;
    }

    public static Call[] getAllActiveCalls() throws SkypeException {
        try {
            String string = "SEARCH ACTIVECALLS";
            String string2 = "CALLS ";
            String string3 = Connector.getInstance().execute(string, string2);
            String string4 = string3.substring(string2.length());
            String[] stringArray = Utils.convertToArray(string4);
            Call[] callArray = new Call[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                callArray[i] = Call.getInstance(stringArray[i]);
            }
            return callArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static Chat[] getAllChats() throws SkypeException {
        return Skype.getAllChats("CHATS");
    }

    public static Chat[] getAllActiveChats() throws SkypeException {
        return Skype.getAllChats("ACTIVECHATS");
    }

    public static Chat[] getAllMissedChats() throws SkypeException {
        return Skype.getAllChats("MISSEDCHATS");
    }

    public static Chat[] getAllRecentChats() throws SkypeException {
        return Skype.getAllChats("RECENTCHATS");
    }

    public static Chat[] getAllBookmarkedChats() throws SkypeException {
        return Skype.getAllChats("BOOKMARKEDCHATS");
    }

    private static Chat[] getAllChats(String string) throws SkypeException {
        try {
            String string2 = "SEARCH " + string;
            String string3 = "CHATS ";
            String string4 = Connector.getInstance().execute(string2, string3);
            String string5 = string4.substring(string3.length());
            String[] stringArray = Utils.convertToArray(string5);
            Chat[] chatArray = new Chat[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                chatArray[i] = Chat.getInstance(stringArray[i]);
            }
            return chatArray;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static void clearCallHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR CALLHISTORY ALL");
    }

    public static void clearChatHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR CHATHISTORY");
    }

    public static void clearVoiceMailHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR VOICEMAILHISTORY");
    }

    public static User getUser(String string) {
        return User.getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatMessageListener(ChatMessageListener chatMessageListener) throws SkypeException {
        Utils.checkNotNull("listener", chatMessageListener);
        Object object = chatMessageListenerMutex;
        synchronized (object) {
            chatMessageListeners.add(chatMessageListener);
            if (Skype.chatMessageListener == null) {
                Skype.chatMessageListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        block10: {
                            String string = connectorMessageEvent.getMessage();
                            if (!string.startsWith("CHATMESSAGE ")) break block10;
                            String string2 = string.substring("CHATMESSAGE ".length());
                            String string3 = string2.substring(0, string2.indexOf(32));
                            String string4 = string2.substring(string2.indexOf(32) + 1);
                            String string5 = string4.substring(0, string4.indexOf(32));
                            if ("STATUS".equals(string5)) {
                                String string6 = string4.substring(string4.indexOf(32) + 1);
                                ChatMessageListener[] chatMessageListenerArray = chatMessageListeners.toArray(new ChatMessageListener[0]);
                                ChatMessage chatMessage = ChatMessage.getInstance(string3);
                                if ("SENT".equals(string6)) {
                                    for (ChatMessageListener chatMessageListener : chatMessageListenerArray) {
                                        try {
                                            chatMessageListener.chatMessageSent(chatMessage);
                                        }
                                        catch (Throwable throwable) {
                                            Skype.handleUncaughtException(throwable);
                                        }
                                    }
                                } else if ("RECEIVED".equals(string6)) {
                                    for (ChatMessageListener chatMessageListener : chatMessageListenerArray) {
                                        try {
                                            chatMessageListener.chatMessageReceived(chatMessage);
                                        }
                                        catch (Throwable throwable) {
                                            Skype.handleUncaughtException(throwable);
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(Skype.chatMessageListener);
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChatMessageListener(ChatMessageListener chatMessageListener) {
        Utils.checkNotNull("listener", chatMessageListener);
        Object object = chatMessageListenerMutex;
        synchronized (object) {
            chatMessageListeners.remove(chatMessageListener);
            if (chatMessageListeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(Skype.chatMessageListener);
                Skype.chatMessageListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCallListener(CallListener callListener) throws SkypeException {
        Utils.checkNotNull("listener", callListener);
        Object object = callListenerMutex;
        synchronized (object) {
            callListeners.add(callListener);
            if (Skype.callListener == null) {
                Skype.callListener = new AbstractConnectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.startsWith("CALL ")) {
                            String string2 = string.substring("CALL ".length());
                            String string3 = string2.substring(0, string2.indexOf(32));
                            String string4 = string2.substring(string2.indexOf(32) + 1);
                            String string5 = string4.substring(0, string4.indexOf(32));
                            if ("STATUS".equals(string5)) {
                                Call call;
                                Call.Status status;
                                block19: {
                                    String string6 = string4.substring(string4.indexOf(32) + 1);
                                    status = Call.Status.valueOf(string6);
                                    call = Call.getInstance(string3);
                                    if (status == Call.Status.ROUTING || status == Call.Status.RINGING) {
                                        Call call2 = call;
                                        synchronized (call2) {
                                            if (call.isCallListenerEventFired()) {
                                                break block19;
                                            }
                                            call.setCallListenerEventFired(true);
                                            CallListener[] callListenerArray = callListeners.toArray(new CallListener[0]);
                                            try {
                                                switch (call.getType()) {
                                                    case OUTGOING_P2P: 
                                                    case OUTGOING_PSTN: {
                                                        for (CallListener callListener : callListenerArray) {
                                                            try {
                                                                callListener.callMaked(call);
                                                            }
                                                            catch (Throwable throwable) {
                                                                Skype.handleUncaughtException(throwable);
                                                            }
                                                        }
                                                        break;
                                                    }
                                                    case INCOMING_P2P: 
                                                    case INCOMING_PSTN: {
                                                        for (CallListener callListener : callListenerArray) {
                                                            try {
                                                                callListener.callReceived(call);
                                                            }
                                                            catch (Throwable throwable) {
                                                                Skype.handleUncaughtException(throwable);
                                                            }
                                                        }
                                                        break;
                                                    }
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Skype.handleUncaughtException(throwable);
                                            }
                                        }
                                    }
                                }
                                call.fireStatusChanged(status);
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(Skype.callListener);
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCallListener(CallListener callListener) {
        Utils.checkNotNull("listener", callListener);
        Object object = callListenerMutex;
        synchronized (object) {
            callListeners.remove(callListener);
            if (callListeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(Skype.callListener);
                Skype.callListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVoiceMailListener(VoiceMailListener voiceMailListener) throws SkypeException {
        Utils.checkNotNull("listener", voiceMailListener);
        Object object = voiceMailListenerMutex;
        synchronized (object) {
            voiceMailListeners.add(voiceMailListener);
            if (Skype.voiceMailListener == null) {
                Skype.voiceMailListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.startsWith("VOICEMAIL ")) {
                            String string2 = string.substring("VOICEMAIL ".length());
                            String string3 = string2.substring(0, string2.indexOf(32));
                            String string4 = string2.substring(string2.indexOf(32) + 1);
                            String string5 = string4.substring(0, string4.indexOf(32));
                            if ("TYPE".equals(string5)) {
                                String string6 = string4.substring(string4.indexOf(32) + 1);
                                VoiceMail.Type type = VoiceMail.Type.valueOf(string6);
                                VoiceMail voiceMail = VoiceMail.getInstance(string3);
                                VoiceMailListener[] voiceMailListenerArray = voiceMailListeners.toArray(new VoiceMailListener[0]);
                                switch (type) {
                                    case OUTGOING: {
                                        for (VoiceMailListener voiceMailListener : voiceMailListenerArray) {
                                            try {
                                                voiceMailListener.voiceMailMade(voiceMail);
                                            }
                                            catch (Throwable throwable) {
                                                Skype.handleUncaughtException(throwable);
                                            }
                                        }
                                        break;
                                    }
                                    case INCOMING: {
                                        for (VoiceMailListener voiceMailListener : voiceMailListenerArray) {
                                            try {
                                                voiceMailListener.voiceMailReceived(voiceMail);
                                            }
                                            catch (Throwable throwable) {
                                                Skype.handleUncaughtException(throwable);
                                            }
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(Skype.voiceMailListener);
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVoiceMailListener(VoiceMailListener voiceMailListener) {
        Utils.checkNotNull("listener", voiceMailListener);
        Object object = voiceMailListenerMutex;
        synchronized (object) {
            voiceMailListeners.remove(voiceMailListener);
            if (voiceMailListeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(Skype.voiceMailListener);
                Skype.voiceMailListener = null;
            }
        }
    }

    public static void setSkypeExceptionHandler(SkypeExceptionHandler skypeExceptionHandler) {
        if (skypeExceptionHandler == null) {
            skypeExceptionHandler = defaultExceptionHandler;
        }
        exceptionHandler = skypeExceptionHandler;
    }

    static void handleUncaughtException(Throwable throwable) {
        exceptionHandler.uncaughtExceptionHappened(throwable);
    }

    private Skype() {
    }

    static {
        chatMessageListenerMutex = new Object();
        chatMessageListeners = new CopyOnWriteArrayList<ChatMessageListener>();
        callListenerMutex = new Object();
        callListeners = new CopyOnWriteArrayList<CallListener>();
        voiceMailListenerMutex = new Object();
        voiceMailListeners = new CopyOnWriteArrayList<VoiceMailListener>();
        userThreadFieldMutex = new Object();
        exceptionHandler = defaultExceptionHandler = new SkypeExceptionHandler(){

            public void uncaughtExceptionHappened(Throwable throwable) {
                throwable.printStackTrace();
            }
        };
    }
}

