/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.EventMessage;
import com.skype.MenuItem;
import com.skype.SkypeException;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.io.File;

public final class SkypeClient {
    private SkypeClient() {
    }

    public static void showSkypeWindow() throws SkypeException {
        Utils.executeWithErrorCheck("FOCUS");
    }

    public static void hideSkypeWindow() throws SkypeException {
        Utils.executeWithErrorCheck("MINIMIZE");
    }

    public static void showAddFriendWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN ADDAFRIEND");
    }

    public static void showAddFriendWindow(String string) throws SkypeException {
        Utils.checkNotNull("skypeId", string);
        Utils.executeWithErrorCheck("OPEN ADDAFRIEND " + string);
    }

    public static void showChatWindow(String string) throws SkypeException {
        Utils.checkNotNull("skypeId", string);
        Utils.executeWithErrorCheck("OPEN IM " + string);
    }

    public static void showChatWindow(String string, String string2) throws SkypeException {
        Utils.checkNotNull("skypeId", string);
        Utils.checkNotNull("message", string2);
        Utils.executeWithErrorCheck("OPEN IM " + string + " " + string2);
    }

    public static void showFileTransferWindow(String string) throws SkypeException {
        Utils.checkNotNull("skypeId", string);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + string);
    }

    public static void showFileTransferWindow(String string, File file) throws SkypeException {
        Utils.checkNotNull("skypeId", string);
        Utils.checkNotNull("folder", file);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + string + " IN " + file);
    }

    public static void showFileTransferWindow(String[] stringArray) throws SkypeException {
        Utils.checkNotNull("skypeIds", stringArray);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + Utils.convertToCommaSeparatedString(stringArray));
    }

    public static void showFileTransferWindow(String[] stringArray, File file) throws SkypeException {
        Utils.checkNotNull("skypeIds", stringArray);
        Utils.checkNotNull("folder", file);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + Utils.convertToCommaSeparatedString(stringArray) + " IN " + file);
    }

    public static void showProfileWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN PROFILE");
    }

    public static void showUserInformationWindow(String string) throws SkypeException {
        Utils.checkNotNull("skypeId", string);
        Utils.executeWithErrorCheck("OPEN USERINFO " + string);
    }

    public static void showConferenceWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CONFERENCE");
    }

    public static void showSearchWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN SEARCH");
    }

    public static void showOptionsWindow(OptionsPage optionsPage) throws SkypeException {
        Utils.executeWithErrorCheck("OPEN OPTIONS " + optionsPage.toString().toLowerCase());
    }

    public static void showCallHistoryTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CALLHISTORY");
    }

    public static void showContactsTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CONTACTS");
    }

    public static void showDialPadTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN DIALPAD");
    }

    public static void showSendContactsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN SENDCONTACTS");
    }

    public static void showBlockedUsersWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN BLOCKEDUSERS");
    }

    public static void showImportContactsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN IMPORTCONTACTS");
    }

    public static void showGettingStartedWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN GETTINGSTARTED");
    }

    public static void showRequestAuthorizationWindow(String string) throws SkypeException {
        Utils.executeWithErrorCheck("OPEN AUTHORIZATION " + string);
    }

    public static void pressButton(Button button) throws SkypeException {
        Utils.executeWithErrorCheck("BTN_PRESSED " + button.getKey());
    }

    public static void releaseButton(Button button) throws SkypeException {
        Utils.executeWithErrorCheck("BTN_RELEASED " + button.getKey());
    }

    public static void openVideoTestWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN VIDEOTEST");
    }

    public static void openVideoOptionsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN OPTIONS VIDEO");
    }

    public static String getUILanguageByISOCode() throws SkypeException {
        return Utils.getProperty("UI_LANGUAGE");
    }

    public static void setUILanguageByISOCode(String string) throws SkypeException {
        Utils.setProperty("UI_LANGUAGE", string);
    }

    public static File getWallPaper() throws SkypeException {
        return new File(Utils.getProperty("WALLPAPER"));
    }

    public static void setWallPaper(File file) throws SkypeException {
        if (file != null) {
            Utils.setProperty("WALLPAPER", file.getAbsolutePath());
        } else {
            Utils.setProperty("WALLPAPER", "");
        }
    }

    public static boolean setSilentMode(boolean bl) throws SkypeException {
        try {
            String string = "SET SILENT_MODE " + (bl ? "ON" : "OFF");
            String string2 = "SILENT_MODE ";
            String string3 = Connector.getInstance().execute(string, string2);
            Utils.checkError(string3);
            String string4 = string3.substring(string2.length());
            return "ON".equals(string4);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return false;
        }
    }

    public static EventMessage addEventMessage(String string) throws SkypeException {
        return SkypeClient.addEventMessage(string, string);
    }

    public static EventMessage addEventMessage(String string, String string2) throws SkypeException {
        Utils.checkNotNull("caption", string);
        Utils.checkNotNull("hint", string2);
        try {
            EventMessage eventMessage = EventMessage.addEventMessage(string, string2);
            String string3 = "CREATE EVENT " + eventMessage.getId() + " CAPTION \"" + string + "\" HINT \"" + string2 + "\"";
            String string4 = "EVENT " + eventMessage.getId() + " CREATED";
            String string5 = Connector.getInstance().execute(string3, string4);
            Utils.checkError(string5);
            return eventMessage;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static void removeEventMessage(EventMessage eventMessage) throws SkypeException {
        eventMessage.dispose();
    }

    public static MenuItem addMenuItem(MenuItem.Context context, String string, String string2, File file, boolean bl, String string3, boolean bl2) throws SkypeException {
        try {
            MenuItem menuItem = MenuItem.addMenuItem(context, string, string2, file, bl, string3, bl2);
            String string4 = "CREATE MENU_ITEM " + menuItem.getId() + " CONTEXT " + context.name().toLowerCase() + " CAPTION \"" + string + "\"";
            if (string2 != null) {
                string4 = string4 + " HINT \"" + string2 + "\"";
            }
            if (file != null) {
                string4 = string4 + " ICON \"" + file.getAbsolutePath() + "\"";
            }
            if (!bl) {
                string4 = string4 + " ENABLED false";
            }
            if (string3 != null) {
                string4 = string4 + " CONTACT_TYPE_FILTER \"" + string3 + "\"";
            }
            if (!bl2) {
                string4 = string4 + " ENABLE_MULTIPLE_CONTACTS false";
            }
            String string5 = "MENU_ITEM " + menuItem.getId() + " CREATED";
            String string6 = Connector.getInstance().execute(string4, string5);
            Utils.checkError(string6);
            return menuItem;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
    }

    public static void removeMenuItem(MenuItem menuItem) throws SkypeException {
        menuItem.dispose();
    }

    public static void setMainWindowState(WindowState windowState) throws SkypeException {
        Utils.setProperty("WINDOWSTATE", windowState.name());
    }

    public static WindowState getMainWindowState() throws SkypeException {
        return WindowState.valueOf(Utils.getProperty("WINDOWSTATE"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindowState {
        NORMAL,
        MINIMIZED,
        MAXIMIZED,
        HIDDEN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Button {
        KEY_0,
        KEY_1,
        KEY_2,
        KEY_3,
        KEY_4,
        KEY_5,
        KEY_6,
        KEY_7,
        KEY_8,
        KEY_9,
        KEY_A,
        KEY_B,
        KEY_C,
        KEY_D,
        KEY_E,
        KEY_F,
        KEY_G,
        KEY_H,
        KEY_I,
        KEY_J,
        KEY_K,
        KEY_L,
        KEY_M,
        KEY_N,
        KEY_O,
        KEY_P,
        KEY_Q,
        KEY_R,
        KEY_S,
        KEY_T,
        KEY_U,
        KEY_V,
        KEY_W,
        KEY_X,
        KEY_Y,
        KEY_Z,
        KEY_SHARP("#"),
        KEY_ASTERISK("*"),
        KEY_PLUS("+"),
        KEY_UP,
        KEY_DOWN,
        KEY_YES,
        KEY_NO,
        KEY_PAGEUP,
        KEY_PAGEDOWN,
        KEY_SKYPE;

        private String key;

        private Button() {
        }

        private Button(String string2) {
            this.key = string2;
        }

        private String getKey() {
            if (this.key != null) {
                return this.key;
            }
            return this.name().substring(this.name().indexOf(95) + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionsPage {
        GENERAL,
        PRIVACY,
        NOTIFICATIONS,
        SOUNDALERTS,
        SOUNDDEVICES,
        HOTKEYS,
        CONNECTION,
        VOICEMAIL,
        CALLFORWARD,
        VIDEO,
        ADVANCED;

    }
}

