/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.VoiceMailStatusChangedListener;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class VoiceMail
extends SkypeObject {
    private static final Map<String, VoiceMail> voiceMails = new HashMap<String, VoiceMail>();
    private static final Object voiceMailStatusChangedListenerFieldMutex = new Object();
    private static ConnectorListener voiceMailStatusChangedListener;
    private final String id;
    private final List<VoiceMailStatusChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private Status oldStatus;
    private SkypeExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VoiceMail getInstance(String string) {
        Map<String, VoiceMail> map = voiceMails;
        synchronized (map) {
            if (!voiceMails.containsKey(string)) {
                voiceMails.put(string, new VoiceMail(string));
            }
            return voiceMails.get(string);
        }
    }

    private VoiceMail(String string) {
        this.id = string;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof VoiceMail) {
            return this.id.equals(((VoiceMail)object).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVoiceMailStatusChangedListener(VoiceMailStatusChangedListener voiceMailStatusChangedListener) throws SkypeException {
        Utils.checkNotNull("listener", voiceMailStatusChangedListener);
        Object object = voiceMailStatusChangedListenerFieldMutex;
        synchronized (object) {
            this.listeners.add(voiceMailStatusChangedListener);
            if (VoiceMail.voiceMailStatusChangedListener == null) {
                VoiceMail.voiceMailStatusChangedListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.startsWith("VOICEMAIL ")) {
                            String string2 = string.substring("VOICEMAIL ".length());
                            String string3 = string2.substring(0, string2.indexOf(32));
                            String string4 = string2.substring(string2.indexOf(32) + 1);
                            String string5 = string4.substring(0, string4.indexOf(32));
                            if ("STATUS".equals(string5)) {
                                VoiceMail voiceMail = VoiceMail.getInstance(string3);
                                String string6 = string4.substring(string4.indexOf(32) + 1);
                                Status status = Status.valueOf(string6);
                                voiceMail.fireStatusChanged(status);
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(VoiceMail.voiceMailStatusChangedListener);
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVoiceMailStatusChangedListener(VoiceMailStatusChangedListener voiceMailStatusChangedListener) {
        Utils.checkNotNull("listener", voiceMailStatusChangedListener);
        Object object = voiceMailStatusChangedListenerFieldMutex;
        synchronized (object) {
            this.listeners.remove(voiceMailStatusChangedListener);
            if (this.listeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(VoiceMail.voiceMailStatusChangedListener);
                VoiceMail.voiceMailStatusChangedListener = null;
            }
        }
    }

    private void fireStatusChanged(Status status) {
        VoiceMailStatusChangedListener[] voiceMailStatusChangedListenerArray = this.listeners.toArray(new VoiceMailStatusChangedListener[0]);
        if (status == this.oldStatus) {
            return;
        }
        this.oldStatus = status;
        for (VoiceMailStatusChangedListener voiceMailStatusChangedListener : voiceMailStatusChangedListenerArray) {
            try {
                voiceMailStatusChangedListener.statusChanged(status);
            }
            catch (Throwable throwable) {
                Utils.handleUncaughtException(throwable, this.exceptionHandler);
            }
        }
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(Utils.getPropertyWithCommandId("VOICEMAIL", this.getId(), "TYPE"));
    }

    public User getPartner() throws SkypeException {
        return User.getInstance(this.getPartnerId());
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("VOICEMAIL", this.getId(), "STATUS"));
    }

    public FailureReason getFailureReason() throws SkypeException {
        return FailureReason.valueOf(this.getProperty("FAILUREREASON"));
    }

    public Date getStartTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public int getDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("DURATION"));
    }

    public int getAllowedDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("ALLOWED_DURATION"));
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("VOICEMAIL", this.getId(), string);
    }

    public void startPlayback() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STARTPLAYBACK");
    }

    public void stopPlayback() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STOPPLAYBACK");
    }

    public void upload() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "UPLOAD");
    }

    public void download() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "DOWNLOAD");
    }

    public void startRecording() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STARTRECORDING");
    }

    public void stopRecording() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STOPRECORDING");
    }

    public void dispose() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "DELETE");
    }

    public void openAndStartPlayback() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN VOICEMAIL " + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinishing() throws SkypeException {
        if (this.getType() != Type.OUTGOING) {
            throw new IllegalStateException("The type must be outgoing.");
        }
        final Object object = new Object();
        VoiceMailStatusChangedListener voiceMailStatusChangedListener = new VoiceMailStatusChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void statusChanged(Status status) throws SkypeException {
                Object object2 = object;
                synchronized (object2) {
                    switch (status) {
                        case UPLOADED: 
                        case UNKNOWN: 
                        case FAILED: {
                            object.notify();
                        }
                    }
                }
            }
        };
        Object object2 = object;
        synchronized (object2) {
            switch (this.getStatus()) {
                case UPLOADED: 
                case UNKNOWN: 
                case FAILED: {
                    break;
                }
                default: {
                    this.addVoiceMailStatusChangedListener(voiceMailStatusChangedListener);
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.removeVoiceMailStatusChangedListener(voiceMailStatusChangedListener);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailureReason {
        MISC_ERROR,
        CONNECT_ERROR,
        NO_VOICEMAIL_PRIVILEGE,
        NO_SUCH_VOICEMAIL,
        FILE_READ_ERROR,
        FILE_WRITE_ERROR,
        RECORDING_ERROR,
        PLAYBACK_ERROR,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOTDOWNLOADED,
        DOWNLOADING,
        UNPLAYED,
        BUFFERING,
        PLAYING,
        PLAYED,
        BLANK,
        RECORDING,
        RECORDED,
        UPLOADING,
        UPLOADED,
        DELETING,
        FAILED,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCOMING,
        OUTGOING,
        DEFAULT_GREETING,
        CUSTOM_GREETING,
        UNKNOWN;

    }
}

