/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.ApplicationAdapter;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.Stream;
import com.skype.StreamAdapter;
import com.skype.TestData;
import junit.framework.TestCase;

public final class Ap2ApAPITest
extends TestCase {
    static final String APPLICATION_NAME = Ap2ApAPITest.class.getName();

    public void testApplication() throws Exception {
        Skype.setDebug(true);
        Application application = Skype.addApplication(APPLICATION_NAME);
        Friend friend = TestData.getFriend();
        this.checkConnectableFriendsBeforeConnecting(application);
        try {
            Stream[] streams = application.connect(friend);
            Ap2ApAPITest.assertEquals((int)1, (int)streams.length);
            Stream stream = streams[0];
            this.checkConnectableFriendsAfterConnecting(application);
            this.checkConnectedFriends(application, friend);
            this.checkWrite(stream);
            this.checkSend(stream);
            this.checkDisconnect(application, stream);
        }
        finally {
            application.finish();
        }
    }

    private void checkConnectableFriendsBeforeConnecting(Application application) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectableFriends();
        Ap2ApAPITest.assertTrue((1 <= connectableFriends.length ? 1 : 0) != 0);
    }

    private void checkConnectableFriendsAfterConnecting(Application application) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectableFriends();
        Ap2ApAPITest.assertTrue((connectableFriends.length >= 0 ? 1 : 0) != 0);
    }

    private void checkConnectedFriends(Application application, Friend friend) throws SkypeException {
        Friend[] connectableFriends = application.getAllConnectedFriends();
        Ap2ApAPITest.assertEquals((int)1, (int)connectableFriends.length);
        Ap2ApAPITest.assertEquals((Object)friend, (Object)connectableFriends[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWrite(Stream stream) throws Exception {
        final Object lock = new Object();
        final String[] result = new String[1];
        stream.addStreamListener(new StreamAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void textReceived(String text) throws SkypeException {
                result[0] = text;
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            stream.write("Hello, World!");
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                Ap2ApAPITest.fail();
            }
        }
        Ap2ApAPITest.assertEquals((String)"Hello, World!", (String)result[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSend(Stream stream) throws Exception {
        final Object lock = new Object();
        final String[] result = new String[1];
        stream.addStreamListener(new StreamAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void datagramReceived(String datagram) throws SkypeException {
                result[0] = datagram;
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            stream.send("Hello, World!");
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                Ap2ApAPITest.fail();
            }
        }
        Ap2ApAPITest.assertEquals((String)"Hello, World!", (String)result[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDisconnect(Application application, Stream stream) throws Exception {
        final Object lock = new Object();
        final boolean[] result = new boolean[1];
        application.addApplicationListener(new ApplicationAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void disconnected(Stream stream) throws SkypeException {
                result[0] = true;
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            stream.write("disconnect");
            try {
                lock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                Ap2ApAPITest.fail();
            }
        }
        Ap2ApAPITest.assertTrue((boolean)result[0]);
    }
}

