/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.windows;

import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorStatusEvent;
import java.io.UnsupportedEncodingException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Display;

public final class WindowsConnector
extends Connector {
    private static WindowsConnector instance;
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int ATTACH_API_AVAILABLE = 32769;
    private static final int HWND_BROADCAST = 65535;
    private static final int WM_COPYDATA = 74;
    private static final int ATTACH_MESSAGE_ID;
    private static final int DISCOVER_MESSAGE_ID;
    private Display display;
    private TCHAR windowClass;
    private int windowHandle;
    private int skypeWindowHandle;

    static {
        ATTACH_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIAttach", true));
        DISCOVER_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIDiscover", true));
    }

    public static synchronized WindowsConnector getInstance() {
        if (instance == null) {
            instance = new WindowsConnector();
        }
        return instance;
    }

    private WindowsConnector() {
    }

    public String getInstalledPath() {
        String result = this.getRegistryValue(-2147483647, "Software\\Skype\\Phone", "SkypePath");
        if (result == null) {
            result = this.getRegistryValue(-2147483646, "Software\\Skype\\Phone", "SkypePath");
        }
        return result;
    }

    private String getRegistryValue(int hKey, String keyName, String dataName) {
        int[] phkResult = new int[1];
        if (OS.RegOpenKeyEx((int)hKey, (TCHAR)new TCHAR(0, keyName, true), (int)0, (int)131097, (int[])phkResult) != 0) {
            return null;
        }
        String result = null;
        int[] lpcbData = new int[1];
        if (OS.RegQueryValueEx((int)phkResult[0], (TCHAR)new TCHAR(0, dataName, true), (int)0, null, null, (int[])lpcbData) == 0) {
            TCHAR lpData;
            result = "";
            int length = lpcbData[0] / TCHAR.sizeof;
            if (length != 0 && OS.RegQueryValueEx((int)phkResult[0], (TCHAR)new TCHAR(0, dataName, true), (int)0, null, (TCHAR)(lpData = new TCHAR(0, length)), (int[])lpcbData) == 0) {
                length = Math.max(0, lpData.length() - 1);
                result = lpData.toString(0, length);
            }
        }
        if (phkResult[0] != 0) {
            OS.RegCloseKey((int)phkResult[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(int timeout) throws ConnectorException {
        final Object object = new Object();
        Thread thread = new Thread("SkypeEventDispatcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WindowsConnector.this.display = new Display();
                WindowsConnector.this.windowClass = new TCHAR(0, "" + System.currentTimeMillis() + (int)(Math.random() * 1000.0), true);
                int messageReceived = new Callback((Object)WindowsConnector.this, "messageReceived", 4).getAddress();
                if (messageReceived == 0) {
                    SWT.error((int)3);
                }
                int hHeap = OS.GetProcessHeap();
                int hInstance = OS.GetModuleHandle(null);
                WNDCLASS lpWndClass = new WNDCLASS();
                lpWndClass.hInstance = hInstance;
                lpWndClass.lpfnWndProc = messageReceived;
                lpWndClass.style = 8200;
                lpWndClass.hCursor = OS.LoadCursor((int)0, (int)32512);
                int byteCount = WindowsConnector.this.windowClass.length() * TCHAR.sizeof;
                lpWndClass.lpszClassName = OS.HeapAlloc((int)hHeap, (int)8, (int)byteCount);
                OS.MoveMemory((int)lpWndClass.lpszClassName, (TCHAR)WindowsConnector.this.windowClass, (int)byteCount);
                OS.RegisterClass((WNDCLASS)lpWndClass);
                WindowsConnector.this.windowHandle = OS.CreateWindowEx((int)0, (TCHAR)WindowsConnector.this.windowClass, null, (int)OS.WS_OVERLAPPED, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)hInstance, null);
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
                while (true) {
                    if (WindowsConnector.this.display.readAndDispatch()) {
                        continue;
                    }
                    WindowsConnector.this.display.sleep();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        Object object2 = object;
        synchronized (object2) {
            try {
                long start = System.currentTimeMillis();
                object.wait(timeout);
                if ((long)timeout <= System.currentTimeMillis() - start) {
                    throw new ConnectorException("The Windows connector couldn't be initialized by timeout.");
                }
            }
            catch (InterruptedException e) {
                throw new ConnectorException("The Windows connector initialization was interrupted.", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connector.Status connect(int timeout) throws ConnectorException {
        final Object object = new Object();
        AbstractConnectorListener listener = new AbstractConnectorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void statusChanged(ConnectorStatusEvent event) {
                Object object2 = object;
                synchronized (object2) {
                    object.notify();
                }
            }
        };
        try {
            this.addConnectorListener(listener, false);
        }
        catch (ConnectorException connectorException) {
            throw new InternalError("The listener couldn't be added.");
        }
        Object object2 = object;
        synchronized (object2) {
            try {
                while (true) {
                    Connector.Status status;
                    OS.SendMessage((int)65535, (int)DISCOVER_MESSAGE_ID, (int)this.windowHandle, (int)0);
                    long start = System.currentTimeMillis();
                    object.wait(timeout);
                    if ((long)timeout <= System.currentTimeMillis() - start) {
                        this.setStatus(Connector.Status.NOT_RUNNING);
                    }
                    if ((status = this.getStatus()) != Connector.Status.PENDING_AUTHORIZATION) {
                        Connector.Status status2 = status;
                        return status2;
                    }
                    Thread.sleep(1000L);
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new ConnectorException("Trying to connect was interrupted.", e);
            }
            finally {
                this.removeConnectorListener(listener);
            }
        }
    }

    protected void sendApplicationName(String applicationName) throws ConnectorException {
        String command = "NAME " + applicationName;
        this.execute(command, new String[]{command}, false);
    }

    int messageReceived(int hwnd, int msg, int wParam, int lParam) {
        if (msg == ATTACH_MESSAGE_ID) {
            switch (lParam) {
                case 1: {
                    this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                    break;
                }
                case 0: {
                    this.skypeWindowHandle = wParam;
                    this.setStatus(Connector.Status.ATTACHED);
                    break;
                }
                case 2: {
                    this.setStatus(Connector.Status.REFUSED);
                    break;
                }
                case 3: {
                    this.setStatus(Connector.Status.NOT_AVAILABLE);
                    break;
                }
                case 32769: {
                    this.setStatus(Connector.Status.API_AVAILABLE);
                    break;
                }
                default: {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
            }
            return 1;
        }
        if (msg == 74 && wParam == this.skypeWindowHandle) {
            int[] data = new int[3];
            OS.MoveMemory((int[])data, (int)lParam, (int)12);
            int cbData = data[1];
            int lpData = data[2];
            int length = cbData;
            byte[] buffer = new byte[length];
            OS.MoveMemory((byte[])buffer, (int)lpData, (int)length);
            byte[] string = new byte[buffer.length - 1];
            System.arraycopy(buffer, 0, string, 0, string.length);
            try {
                String message = new String(string, "UTF-8");
                this.fireMessageReceived(message);
                return 1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return OS.DefWindowProc((int)hwnd, (int)msg, (int)wParam, (int)lParam);
    }

    protected void disposeImpl() {
        throw new UnsupportedOperationException("WindowsConnector#disposeImpl() is not implemented yet.");
    }

    protected void sendCommand(final String command) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                try {
                    byte[] data = (String.valueOf(command) + "\u0000").getBytes("UTF-8");
                    int hHeap = OS.GetProcessHeap();
                    int pMessage = OS.HeapAlloc((int)hHeap, (int)8, (int)data.length);
                    OS.MoveMemory((int)pMessage, (byte[])data, (int)data.length);
                    int[] nArray = new int[3];
                    nArray[1] = data.length;
                    nArray[2] = pMessage;
                    OS.SendMessage((int)WindowsConnector.this.skypeWindowHandle, (int)74, (int)WindowsConnector.this.windowHandle, (int[])nArray);
                    OS.HeapFree((int)hHeap, (int)0, (int)pMessage);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        });
    }

    public static synchronized /* bridge */ /* synthetic */ Connector getInstance() {
        return WindowsConnector.getInstance();
    }
}

