/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;

public class BitSet
implements IntSet,
Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n) {
        this.bits = new long[(n - 1 >> 6) + 1];
    }

    public void add(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | BitSet.bitMask(n);
    }

    public void addAll(IntSet intSet) {
        if (intSet instanceof BitSet) {
            this.orInPlace((BitSet)intSet);
        } else if (intSet instanceof IntervalSet) {
            IntervalSet intervalSet = (IntervalSet)intSet;
            Iterator<Interval> iterator = intervalSet.intervals.iterator();
            while (iterator.hasNext()) {
                Interval interval = iterator.next();
                this.orInPlace(BitSet.range(interval.a, interval.b));
            }
        } else {
            throw new IllegalArgumentException("can't add " + intSet.getClass().getName() + " to BitSet");
        }
    }

    public void addAll(int[] nArray) {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.add(n);
        }
    }

    public void addAll(Iterable iterable) {
        if (iterable == null) {
            return;
        }
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (!(t instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer n = (Integer)t;
            this.add(n);
        }
    }

    public IntSet and(IntSet intSet) {
        BitSet bitSet = (BitSet)this.clone();
        bitSet.andInPlace((BitSet)intSet);
        return bitSet;
    }

    public void andInPlace(BitSet bitSet) {
        int n;
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (n = n2 - 1; n >= 0; --n) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n];
        }
        for (n = n2; n < this.bits.length; ++n) {
            this.bits[n] = 0L;
        }
    }

    private static final long bitMask(int n) {
        int n2 = n & 0x3F;
        return 1L << n2;
    }

    public void clear() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            this.bits[i] = 0L;
        }
    }

    public void clear(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int size() {
        int n = 0;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long l = this.bits[i];
            if (l == 0L) continue;
            for (int j = 63; j >= 0; --j) {
                if ((l & 1L << j) == 0L) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        block5: {
            int n;
            int n2;
            BitSet bitSet;
            block4: {
                if (object == null || !(object instanceof BitSet)) {
                    return false;
                }
                bitSet = (BitSet)object;
                n2 = Math.min(this.bits.length, bitSet.bits.length);
                for (n = 0; n < n2; ++n) {
                    if (this.bits[n] == bitSet.bits[n]) continue;
                    return false;
                }
                if (this.bits.length <= n2) break block4;
                for (n = n2 + 1; n < this.bits.length; ++n) {
                    if (this.bits[n] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (bitSet.bits.length <= n2) break block5;
            for (n = n2 + 1; n < bitSet.bits.length; ++n) {
                if (bitSet.bits[n] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public void growToInclude(int n) {
        int n2 = Math.max(this.bits.length << 1, this.numWordsToHold(n));
        long[] lArray = new long[n2];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public boolean member(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & BitSet.bitMask(n)) != 0L;
    }

    public int getSingleElement() {
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            return i;
        }
        return -7;
    }

    public boolean isNil() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public IntSet complement() {
        BitSet bitSet = (BitSet)this.clone();
        bitSet.notInPlace();
        return bitSet;
    }

    public IntSet complement(IntSet intSet) {
        if (intSet == null) {
            return this.complement();
        }
        return intSet.subtract(this);
    }

    public void notInPlace() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int n) {
        this.notInPlace(0, n);
    }

    public void notInPlace(int n, int n2) {
        this.growToInclude(n2);
        for (int i = n; i <= n2; ++i) {
            int n3;
            int n4 = n3 = BitSet.wordNumber(i);
            this.bits[n4] = this.bits[n4] ^ BitSet.bitMask(i);
        }
    }

    private final int numWordsToHold(int n) {
        return (n >> 6) + 1;
    }

    public static BitSet of(int n) {
        BitSet bitSet = new BitSet(n + 1);
        bitSet.add(n);
        return bitSet;
    }

    public static BitSet of(Collection collection) {
        BitSet bitSet = new BitSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            bitSet.add(n);
        }
        return bitSet;
    }

    public static BitSet of(IntSet intSet) {
        if (intSet == null) {
            return null;
        }
        if (intSet instanceof BitSet) {
            return (BitSet)intSet;
        }
        if (intSet instanceof IntervalSet) {
            BitSet bitSet = new BitSet();
            bitSet.addAll(intSet);
            return bitSet;
        }
        throw new IllegalArgumentException("can't create BitSet from " + intSet.getClass().getName());
    }

    public static BitSet of(Map map) {
        return BitSet.of(map.keySet());
    }

    public static BitSet range(int n, int n2) {
        BitSet bitSet = new BitSet(n2 + 1);
        for (int i = n; i <= n2; ++i) {
            int n3;
            int n4 = n3 = BitSet.wordNumber(i);
            bitSet.bits[n4] = bitSet.bits[n4] | BitSet.bitMask(i);
        }
        return bitSet;
    }

    public IntSet or(IntSet intSet) {
        if (intSet == null) {
            return this;
        }
        BitSet bitSet = (BitSet)this.clone();
        bitSet.orInPlace((BitSet)intSet);
        return bitSet;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n = Math.min(this.bits.length, bitSet.bits.length);
        for (int i = n - 1; i >= 0; --i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] | bitSet.bits[i];
        }
    }

    public void remove(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int n) {
        long[] lArray = new long[n];
        int n2 = Math.min(n, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n2);
        this.bits = lArray;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet bitSet) {
        if (bitSet == null) {
            return false;
        }
        return ((Object)this.and(bitSet)).equals(this);
    }

    public void subtractInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        for (int i = 0; i < this.bits.length && i < bitSet.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (bitSet.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public IntSet subtract(IntSet intSet) {
        if (intSet == null || !(intSet instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = (BitSet)this.clone();
        bitSet.subtractInPlace((BitSet)intSet);
        return bitSet;
    }

    public List toList() {
        throw new NoSuchMethodError("BitSet.toList() unimplemented");
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n = 0;
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Grammar grammar) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ",";
        boolean bl = false;
        stringBuffer.append('{');
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (i > 0 && bl) {
                stringBuffer.append(string);
            }
            if (grammar != null) {
                stringBuffer.append(grammar.getTokenDisplayName(i));
            } else {
                stringBuffer.append(i);
            }
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toString(String string, List list) {
        if (list == null) {
            return this.toString(null);
        }
        String string2 = "";
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = i >= list.size() ? string2 + "'" + (char)i + "'" : (list.get(i) == null ? string2 + "'" + (char)i + "'" : string2 + (String)list.get(i));
        }
        return string2;
    }

    public String toStringOfHalfWords() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bits.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            long l = this.bits[i];
            stringBuffer.append(l &= 0xFFFFFFFFL);
            stringBuffer.append("UL");
            stringBuffer.append(", ");
            l = this.bits[i] >>> 32;
            stringBuffer.append(l &= 0xFFFFFFFFL);
            stringBuffer.append("UL");
        }
        return stringBuffer.toString();
    }

    public String toStringOfWords() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bits.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.bits[i]);
            stringBuffer.append("L");
        }
        return stringBuffer.toString();
    }

    public String toStringWithRanges() {
        return this.toString();
    }

    private static final int wordNumber(int n) {
        return n >> 6;
    }
}

