/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr3;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.tool.BuildDependencyGenerator;
import org.antlr.tool.Grammar;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.antlr3.AntlrHelper;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public abstract class Antlr3PluginMojo
extends AbstractMojo {
    Set includes = new HashSet();
    Set excludes = new HashSet();
    protected boolean debug = false;
    protected boolean trace = false;
    protected boolean profile = false;
    private Tool tool;
    private int conversionTimeout;
    protected MavenProject project;

    abstract File getSourceDirectory();

    abstract File getOutputDirectory();

    abstract File getLibDirectory();

    abstract void addSourceRoot(File var1);

    public void execute() throws MojoExecutionException {
        File outputDir = this.getOutputDirectory();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        this.tool = new Tool();
        DFA.MAX_TIME_PER_DFA_CREATION = this.conversionTimeout;
        File libFile = this.getLibDirectory();
        if (libFile != null) {
            this.tool.processArgs(new String[]{"-lib", libFile.getAbsolutePath()});
        }
        File srcDir = this.getSourceDirectory();
        try {
            this.processGrammarFiles(srcDir, outputDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
        if (this.project != null) {
            this.addSourceRoot(outputDir);
        }
    }

    private void processGrammarFiles(File sourceDirectory, File outputDirectory) throws TokenStreamException, RecognitionException, IOException, InclusionScanException {
        SuffixMapping mapping = new SuffixMapping("g", Collections.EMPTY_SET);
        Set includes = this.getIncludesPatterns();
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(includes, this.excludes);
        scan.addSourceMapping((SourceMapping)mapping);
        Set grammarFiles = scan.getIncludedSources(sourceDirectory, null);
        if (grammarFiles.isEmpty()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"No grammars to process");
            }
        } else {
            boolean built = false;
            Iterator i = grammarFiles.iterator();
            while (i.hasNext()) {
                built |= this.processGrammarFile(((File)i.next()).getPath(), sourceDirectory, outputDirectory);
            }
            if (!built && this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"No grammars processed; generated files are up to date");
            }
        }
    }

    public Set getIncludesPatterns() {
        if (this.includes == null || this.includes.isEmpty()) {
            return Collections.singleton("**/*.g");
        }
        return this.includes;
    }

    private boolean processGrammarFile(String grammarFileName, File sourceDirectory, File outputDirectory) throws TokenStreamException, RecognitionException, IOException {
        String sourceSubdir = this.findSourceSubdir(sourceDirectory, grammarFileName);
        File outputSubdir = new File(outputDirectory, sourceSubdir);
        this.tool.setOutputDirectory(outputSubdir.getPath());
        BuildDependencyGenerator dep = new BuildDependencyGenerator(this.tool, grammarFileName);
        List outputFiles = dep.getGeneratedFileList();
        List dependents = dep.getDependenciesFileList();
        if (AntlrHelper.buildRequired(grammarFileName, outputFiles)) {
            this.generate(grammarFileName);
            return true;
        }
        return false;
    }

    private String findSourceSubdir(File sourceDirectory, String grammarFileName) {
        String srcPath = sourceDirectory.getPath();
        if (!grammarFileName.startsWith(srcPath)) {
            throw new IllegalArgumentException("expected " + grammarFileName + " to be prefixed with " + sourceDirectory);
        }
        File unprefixedGrammarFileName = new File(grammarFileName.substring(srcPath.length()));
        return unprefixedGrammarFileName.getParent();
    }

    private void generate(String grammarFileName) throws TokenStreamException, RecognitionException, IOException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Processing grammar " + grammarFileName));
        }
        Grammar grammar = this.tool.getGrammar(grammarFileName);
        this.processGrammar(grammar);
        String lexerGrammarStr = grammar.getLexerGrammar();
        if (grammar.type == 4 && lexerGrammarStr != null) {
            String lexerGrammarFileName = grammar.getImplicitlyGeneratedLexerFileName();
            Writer w = this.tool.getOutputFile(grammar, lexerGrammarFileName);
            w.write(lexerGrammarStr);
            w.close();
            StringReader sr = new StringReader(lexerGrammarStr);
            Grammar lexerGrammar = new Grammar();
            lexerGrammar.setTool(this.tool);
            File lexerGrammarFullFile = new File(this.tool.getFileDirectory(lexerGrammarFileName), lexerGrammarFileName);
            lexerGrammar.setFileName(lexerGrammarFullFile.toString());
            lexerGrammar.importTokenVocabulary(grammar);
            lexerGrammar.setGrammarContent((Reader)sr);
            sr.close();
            this.processGrammar(lexerGrammar);
        }
    }

    private void processGrammar(Grammar grammar) {
        String language = (String)grammar.getOption("language");
        if (language != null) {
            CodeGenerator generator = new CodeGenerator(this.tool, grammar, language);
            grammar.setCodeGenerator(generator);
            generator.setDebug(this.debug);
            generator.setProfile(this.profile);
            generator.setTrace(this.trace);
            generator.genRecognizer();
        }
    }
}

