package net.twainy.kippah.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Enumeration;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahNetworkException;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.MessageContext;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.share.config.Config;
import net.twainy.kippah.share.config.ConfigLoaderFactory;
import net.twainy.kippah.translator.KsmpObjectTranslator;

import com.spinn3r.log5j.Logger;

/**
 * KippahMessageServerɃbZ[W𑗐M邾̃VvȃNCAg
 * @author twainy
 */
public class SimpleMessageClient implements MessageClient {
	// ftHg|[gio[
	int portNumber = 5555;
	private InetSocketAddress address;
	private SocketChannel channel;
	Logger log = Logger.getLogger();
	static Charset UTFCharset;
	Config config;
	MessageContext context;
	/**
	 * RXgN^
	 * ݒǂݍޏs
	 */
    public SimpleMessageClient() {
    	loadConfig();
    }
    /**
     * T[oƐڑ邱Ƃɂ
     * NCAgIPAhX肷
     */
    private InetAddress getInetAddress() throws KippahNetworkException{
    	Enumeration<NetworkInterface> ifs;
		try {
			ifs = NetworkInterface.getNetworkInterfaces();
		} catch (SocketException e) {
			throw new KippahNetworkException("lbg[NC^tF[X擾ł܂");
		}
    	while(ifs.hasMoreElements())
    	{
    		NetworkInterface nif = ifs.nextElement();
    		Enumeration<InetAddress> addrs = nif.getInetAddresses();
    		while (addrs.hasMoreElements()) {
				InetAddress address = (InetAddress) addrs.nextElement();
		        if(connectTest(address, portNumber))return address;
			}
    	}
    	throw new KippahNetworkException("T[oƂ̐ڑmo܂ł");
    }
    
    /**
     * |[gԍw肷
     */
    public SimpleMessageClient(int portNumber){
    	this.portNumber = portNumber;
    }
    
    /**
     * T[oւ̐ڑeXgs
     */
    public boolean connectTest(InetAddress address, int portNumber){
    	try{
	        channel = SocketChannel.open();
	        InetSocketAddress sock = new InetSocketAddress(address, portNumber);
	        channel.connect(sock);
	        channel.close();
		}catch(IOException e){
			return false;
		}
    	return true;
    }
    /**
     * bZ[W𑗐M郁\bh
     * bZ[WoCgɕϊđM
     * @param MmessageIuWFNg 
     */
	public RequestMessage send(RequestMessage message) throws KippahRuntimeException{
		try{
			context = message.getMessageContext();
			if(context == null)throw new KippahRuntimeException("Message Context is not initialized.", null, KippahFatalReason.MESSAGE_CONTEXT_IS_NOT_INITIALIZED);
            channel = SocketChannel.open();
            address = new InetSocketAddress(InetAddress.getLocalHost(), portNumber);
            channel.connect(address);

            log.info("send message object:" + message);
            String ksmpMessage = KsmpObjectTranslator.translate(message);
            log.info("send message by ksmp protocol :" + ksmpMessage);
            ByteBuffer ksmpByteMessage = UTFCharset.encode(ksmpMessage);
            channel.write(ksmpByteMessage);
            // T[õvC̓ǂݍ
            ByteBuffer reply = ByteBuffer.allocate(1024);
            channel.read(reply); // ǂݍ
            reply.flip();
            String rep = UTFCharset.decode(reply).toString();
            log.info("reply message" + rep);
            channel.close();
            return null;
        }catch(IOException e){
            throw new KippahRuntimeException("Can't write message to server socket." + address, e, KippahFatalReason.CANT_CONNECT_TO_SERVER);
        }
	}
	/**
	 * ݒt@C̓ǂݍ
	 */
	private void loadConfig(){
		
		config =  ConfigLoaderFactory.getInstance().load();
	}
	
	
	/**
	 * ConnectionN[Y     
	 */
    public void close(){
    	try{
            channel.close();
    	}catch(IOException e){
        	throw new KippahRuntimeException("Can't close client socket.", e, KippahFatalReason.FAIL_TO_STOP_CLIENT);
    	}
    }
    
    static{
    	UTFCharset = Charset.forName("UTF-8");
    }
}
