package net.twainy.kippah.message;

import java.util.LinkedHashMap;
import java.util.Map;

import net.twainy.kippah.message.RequestMessage.MessageMimeType;
import net.twainy.kippah.message.RequestMessage.MethodType;
import net.twainy.kippah.message.ResponseMessage.ResponseType;
import net.twainy.kippah.sender.MessageSender.SenderType;

/**
 * bZ[W̃X|Xɂ镶킷
 * bZ[W̓Xg[`œn̂ŁAwb_{߂̃NX
 * KSMPvgRǂݍݎɂ
 * @author twainy
 *
 */
public class MessageContext {
	SenderType senderType;
	String requestURI;
	String protocolVersion; 
	MessageOperationType messageOperationType;

	/**
	 * bZ[W̑
	 * Receiver̎ނRequestURIMessageServer߂邱ƂɂČ肷
	 * @author twainy
	 */
	public enum MessageOperationType{
		CALL,
		CHAT
	}

	// MessageOperatioñvpeB
	Map<String, String> messageOperationMap = new LinkedHashMap<String, String>();
	
	
	public String getRequestURI() {
		return requestURI;
	}
	
	/**
	 * gpĂvgR̃@[WԂ
	 * @return
	 */
	public String getProtocolVersion(){
		return protocolVersion = "1.0";
	}
	/**
	 * 
	 * @param requestURI
	 */
	public void setRequestURI(String requestURI) {
		this.requestURI = requestURI;
	}

	public SenderType getMessageSenderType() {
		return senderType;
	}

	public void setMessageSenderType(SenderType senderType) {
		this.senderType = senderType;
	}

	
	public RequestMessage createRequestMessage(MethodType method,MessageMimeType mime, String message){
		return new RequestMessage(this, method, mime, message);
	}
	
	public ResponseMessage createResponseMessage(ResponseType responseType, String message){
		return new ResponseMessage(this, responseType, message);
	}
	public MessageContext(SenderType senderType, String requestURI){
		this.senderType = senderType;
		this.requestURI = requestURI;
	}
	
	public String getTargetUserId(){
		return "wakasugi."; 
	}
	
	public MessageOperationType getMessageOperationType(){
		return messageOperationType;
	}
}
