package net.twainy.kippah.message;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.sender.MessageSender;
import net.twainy.kippah.sender.MessageSender.SenderType;

public class MessageContextFactory {
	/**
	 * p[TĂяoAK؂MessageContext쐬邽߂̃\bh
	 * p[TɂĂ
	 * @param type
	 * @param senderType
	 * @param requestURI
	 * @return
	 */
	public static MessageContext createMessageContext(MessageSender.SenderType senderType, String requestURI){
		return new MessageContext(senderType, requestURI);
	}
	/**
	 * p[TĂяoAK؂MessageContext쐬邽߂̃\bh
	 * p[TɂĂ
	 * @param type
	 * @param senderType
	 * @param requestURI
	 * @return
	 */
	public static MessageContext createMessageContext(String senderType, String requestURI){
		return new MessageContext(getMessageSenderType(senderType), requestURI);
	}

	/**
	 * StringŎw肳ꂽMessageSenderTypeϊ
	 * @param mType "REQUEST""RESPONSE" 
	 * @return
	 */
	private static SenderType getMessageSenderType(String mSenderType){
		if(mSenderType == null)return null;
		if(mSenderType.equals("SIMPLE")){
			return SenderType.SIMPLE;
		}else if(mSenderType.equals("SKYPE")){
			return SenderType.SKYPE;
		}else{
			throw new KippahRuntimeException("Unknown MessageType:[" + mSenderType + "]", null, KippahFatalReason.FAIL_TO_FIND_MESSAGE_TYPE);
		}
	}
}
