package net.twainy.kippah.receiver;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.Skype;
import com.skype.SkypeException;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.RequestMessage;

/**
 * Skypẽ`bgbZ[WM邽߂MessageReceiver
 * M̃bZ[W𔻕ʂ
 * @author wakasugi
 *
 */
public class SkypeMessageReceiver implements MessageStreamReceiver {
	private static Log log = LogFactory.getLog(SkypeMessageReceiver.class);
	public Thread start() {
    	log.info("Start SimpleMessageStreamReceiver thread.");
		Thread thread = new Thread(this);
		thread.start();
		return thread;
	}
	public ReceiverType getId() {
		return ReceiverType.SkypeStream;
	}
	public void accept(RequestMessage msg) {
		// TODO ꂽ\bhEX^u
		
	}
	public RequestMessage parseData(InputStream s) throws IOException {
		
		// TODO ꂽ\bhEX^u
		return null;
	}
	private void communication() throws IOException, SkypeException{
		Skype.addChatMessageListener(new ChatMessageListener(){
			public void chatMessageReceived(ChatMessage chatMessage)
					throws SkypeException {
				// `bgbZ[WMƂ
				System.out.println("ChatMessage:" +  chatMessage.getContent());
			}
			public void chatMessageSent(ChatMessage chatMessage) throws SkypeException {
				// `bgbZ[W𑗐MƂBȂ
				System.out.println("SentChatMessage:" +  chatMessage.getContent());
			}
		});
	}
	public void run(){
		try{
			communication();
		}catch(IOException e){
			new KippahRuntimeException("Arise IOException", e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
		}catch(SkypeException e){
			new KippahRuntimeException("Arise SkypeException", e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
		}
	}
	public static void main(String[] args) {
		new SkypeMessageReceiver().start();
	}
}
