package net.twainy.kippah.sender.operation;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.MessageContext;
import net.twainy.kippah.message.MessageContextFactory;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.message.ResponseMessage;
import net.twainy.kippah.message.RequestMessage.MessageMimeType;
import net.twainy.kippah.message.ResponseMessage.ResponseType;
import net.twainy.kippah.sender.SkypeMessageSender;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.skype.Skype;
import com.skype.SkypeException;
/**
 * Create chat notification to requested uri.
 * @author wakasugi
 */
public class SkypeChatOperationExecuter implements
		OperationExecuter {
    private final static Log log = LogFactory.getLog(SkypeMessageSender.class);
	public static void setup() throws SkypeException {
    	Skype.setDebug(true);
        Skype.setDeamon(true);
    }	
	public ResponseMessage exec(RequestMessage message) {
		try{
            setup();
            String targetUserId = message.getMessageContext().getTargetUserId();
            if(targetUserId == null)throw new KippahRuntimeException("Target User Id is not set.", new NullPointerException(),KippahFatalReason.FAIL_TO_FIND_TARGET_USER_ID);
            log.info("send message to:" + targetUserId);
            Skype.chat(targetUserId).send(message.getMessage());
		}catch(SkypeException e){
			throw new KippahRuntimeException("Occur skype exception.", e, KippahFatalReason.SKYPE_ERROR);
		}
		return message.getMessageContext().createResponseMessage(ResponseType.OK, "open message window");
	}
}
