package net.twainy.kippah.share.config;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.receiver.MessageReceiver;
import net.twainy.kippah.receiver.MessageReceiver.ReceiverType;
import net.twainy.kippah.sender.MessageSender;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.xml.DocumentContainer;

import com.spinn3r.log5j.Logger;
import com.sun.corba.se.spi.activation.ServerHolder;


public class XMLConfigLoader extends ConfigLoader {
    public static final Logger log = Logger.getLogger();

    public static final String DEFAULT_CONFIG_FILE_PATH="/res/server-config.xml";

    public Config load(){
    	log.info("test");
        return load(DEFAULT_CONFIG_FILE_PATH);
    }
    
    
	public Config load(String filePath) {
	    JXPathContextFactory cfactory;
	    String configFilePath;
	    DocumentContainer container;
	    JXPathContext context;
	    Config config;
    	configFilePath = filePath;
        System.setProperty(ConfigLoader.ConfigKey.CONFIG_FILE_PATH.toString(), configFilePath);
        cfactory = JXPathContextFactory.newInstance();
        
        // DocumentContainerւXMLParser̃Zbg
        container = new DocumentContainer(XMLConfigLoader.class.getResource(filePath));
        config = new Config();
        context = cfactory.newContext(null,container.getValue());
		log.info("load xml configuration file :" + configFilePath);
		try{
			String serverHostname = (String)context.getValue("/kippah-client-config/server/hostname");
			if(serverHostname != null){
				InetAddress serverIPAddress;
				log.info("load xml configuration file : server hostname :" + serverHostname);
				try{
					serverIPAddress = InetAddress.getByName(serverHostname);
					config.setServerIPAddress(serverIPAddress);
				}catch(UnknownHostException e){
					e.printStackTrace();
				}
			}
		}catch(JXPathException e){
			// ȂĂ͂Ȃ
		}
		try{
			String serverPortNumber = (String)context.getValue("/kippah-client-config/server/port");
			Integer portnum;
			if(serverPortNumber != null){
				try{
					log.info("load xml configuration file : server port number :" + serverPortNumber);
					portnum = Integer.parseInt(serverPortNumber);
					config.setServerPortNumber(portnum);
				}catch(NumberFormatException e){
					e.printStackTrace();
				}
			}
		}catch(JXPathException e){
			// ȂĂ͂Ȃ
		}
		config = loadMessageSenders(config, context);
		config = loadMessageReceiver(config, context);

		log.info("Load Config " + config);
        // SendeřJԂɂAContext擾B
		return config;
	}
	/**
	 * MessageSender擾āAConfigɐݒ肷
	 * @param config
	 * @param context
	 * @return
	 */
	private Config loadMessageSenders(Config config, JXPathContext context){
        Iterator<String> iter = context.iterate("/kippah-config/sender/@class");
        Map<MessageSender.SenderType, MessageSender> messageMap = new HashMap<MessageSender.SenderType, MessageSender>();

        while(iter.hasNext()){
        	String className = iter.next();
        	log.info(className);
            try{
                MessageSender sender = (MessageSender)Class.forName(className).newInstance();
                config.addSender(sender.getId(), sender);
            }catch(ClassNotFoundException e){
            	throw new KippahRuntimeException("Class not found. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_SENDER);
            }catch(InstantiationException e){
            	throw new KippahRuntimeException("Can't create instance. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_SENDER);
            }catch(IllegalArgumentException e){
            	throw new KippahRuntimeException("Don't have default constructor. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_SENDER);
            }catch(IllegalAccessException e){
            	throw new KippahRuntimeException("Can't access class. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_SENDER);
            }
        }
        return config; 
	}
	/**
	 * MessageReceiver擾āAConfigɐݒ肷
	 * @param context
	 * @return
	 */
	private Config loadMessageReceiver(Config config,JXPathContext context){
        Iterator<String> iter = context.iterate("/kippah-config/receiver/@class");
        Map<MessageReceiver.ReceiverType, MessageReceiver> messageMap = new HashMap<MessageReceiver.ReceiverType, MessageReceiver>();
        while(iter.hasNext()){
        	String className = iter.next();
        	log.info(className);
            try{
                MessageReceiver receiver = (MessageReceiver)Class.forName(className).newInstance();
                config.addReceiver(receiver.getId(), receiver);
            }catch(ClassNotFoundException e){
            	throw new KippahRuntimeException("Class not found. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_RECEIVER);
            }catch(InstantiationException e){
            	throw new KippahRuntimeException("Can't create instance. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_RECEIVER);
            }catch(IllegalArgumentException e){
            	throw new KippahRuntimeException("Don't have default constructor. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_RECEIVER);
            }catch(IllegalAccessException e){
            	throw new KippahRuntimeException("Can't access class. class=" + className, e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_RECEIVER);
            }
        }
        return config;
    }
	
	
}