package net.twainy.kippah.client;

import net.twainy.kippah.message.MessageContext;
import net.twainy.kippah.message.MessageContextFactory;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.message.RequestMessage.MessageMimeType;
import net.twainy.kippah.message.RequestMessage.MethodType;
import net.twainy.kippah.sender.MessageSender;

import org.junit.Test;

public class KippahMessageClientTest {

	@Test
	public void testSend() throws Exception {
		MessageContext context = MessageContextFactory.createMessageContext(MessageSender.SenderType.SIMPLE, "kippah:wakasugi.@127.0.0.1");
		RequestMessage message = context.createRequestMessage(MethodType.CALL,MessageMimeType.TEXT,"Message");
		MessageClient client = new KSMPMessageClient();
		client.send(message);
		message = context.createRequestMessage(MethodType.CALL,MessageMimeType.TEXT,"日本語テスト");
		client.send(message);
	}

}
