/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class SMS
extends SkypeObject {
    private static final Map<String, SMS> smses = new HashMap<String, SMS>();
    private final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SMS getInstance(String id) {
        Map<String, SMS> map = smses;
        synchronized (map) {
            if (!smses.containsKey(id)) {
                smses.put(id, new SMS(id));
            }
            return smses.get(id);
        }
    }

    private SMS(String newId) {
        assert (newId != null);
        this.id = newId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof SMS) {
            return this.getId().equals(((SMS)compared).getId());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getContent() throws SkypeException {
        return this.getProperty("BODY");
    }

    void setContent(String newValue) throws SkypeException {
        this.setSMSProperty("BODY", newValue);
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(this.getProperty("STATUS"));
    }

    public FailureReason getFailureReason() throws SkypeException {
        return FailureReason.valueOf(this.getProperty("FAILUREREASON"));
    }

    public boolean isCheckedFailure() throws SkypeException {
        return !Boolean.parseBoolean(this.getProperty("IS_FAILED_UNSEEN"));
    }

    public void toCheckedFailure() throws SkypeException {
        try {
            String command = "SET SMS " + this.getId() + " SEEN";
            String response = Connector.getInstance().execute(command);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public Date getTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public BigDecimal getPrice() throws SkypeException {
        return new BigDecimal(this.getProperty("PRICE")).scaleByPowerOfTen(-Integer.parseInt(this.getProperty("PRICE_PRECISION")));
    }

    public String getCurrencyUnit() throws SkypeException {
        return this.getProperty("PRICE_CURRENCY");
    }

    public String getReplyToNumber() throws SkypeException {
        return this.getProperty("REPLY_TO_NUMBER");
    }

    public void setReplyToNumber(String newValue) throws SkypeException {
        this.setSMSProperty("REPLY_TO_NUMBER", newValue);
    }

    public String[] getAllTargetNumbers() throws SkypeException {
        return this.getProperty("TARGET_NUMBERS").split(", ");
    }

    public void setAllTargetNumbers(String[] newValues) throws SkypeException {
        this.setSMSProperty("TARGET_NUMBERS", Utils.convertToCommaSeparatedString(newValues));
    }

    public TargetStatus[] getAllTargetStatuses() throws SkypeException {
        String data = this.getProperty("TARGET_STATUSES");
        ArrayList<TargetStatus> r = new ArrayList<TargetStatus>();
        String[] stringArray = data.split(", ");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String targetStatus = stringArray[n];
            String[] elements = targetStatus.split("=");
            r.add(new TargetStatus(elements[0], TargetStatus.Status.valueOf(elements[1])));
            ++n;
        }
        return r.toArray(new TargetStatus[0]);
    }

    public String[] getAllContentChunks() throws SkypeException {
        int chunkCount = Integer.parseInt(this.getProperty("CHUNKING"));
        String[] r = new String[chunkCount];
        int i = 0;
        while (i < chunkCount) {
            r[i] = this.getProperty("CHUNK " + i);
            ++i;
        }
        return r;
    }

    void send() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER SMS " + this.getId() + " SEND");
    }

    public void delete() throws SkypeException {
        Utils.executeWithErrorCheck("DELETE SMS " + this.getId());
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("SMS", this.getId(), name);
    }

    private void setSMSProperty(String name, String value) throws SkypeException {
        Utils.setProperty("SMS", this.getId(), name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCOMING,
        OUTGOING,
        CONFIRMATION_CODE_REQUEST,
        CONFIRMATION_CODE_SUBMIT,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RECEIVED,
        READ,
        COMPOSING,
        SENDING_TO_SERVER,
        SENT_TO_SERVER,
        DELIVERED,
        SOME_TARGETS_FAILED,
        FAILED,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailureReason {
        MISC_ERROR,
        SERVER_CONNECT_FAILED,
        NO_SMS_CAPABILITY,
        INSUFFICIENT_FUNDS,
        INVALID_CONFIRMATION_CODE,
        USER_BLOCKED,
        IP_BLOCKED,
        NODE_BLOCKED,
        UNKNOWN;

    }

    public static final class TargetStatus {
        private final String number;
        private final Status status;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !TargetStatus.class.desiredAssertionStatus();
        }

        TargetStatus(String newNumber, Status newStatus) {
            if (!$assertionsDisabled && newNumber == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && newStatus == null) {
                throw new AssertionError();
            }
            this.number = newNumber;
            this.status = newStatus;
        }

        public int hashCode() {
            return (String.valueOf(this.number) + "/" + (Object)((Object)this.status)).hashCode();
        }

        public boolean equals(Object compared) {
            if (compared instanceof TargetStatus) {
                TargetStatus comparedTargetStatus = (TargetStatus)compared;
                return comparedTargetStatus.number.equals(this.number) && comparedTargetStatus.status.equals((Object)this.status);
            }
            return false;
        }

        public String getNumber() {
            return this.number;
        }

        public Status getStatus() {
            return this.status;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            TARGET_ANALYZING,
            TARGET_UNDEFINED,
            TARGET_ACCEPTABLE,
            TARGET_NOT_ROUTABLE,
            TARGET_DELIVERY_PENDING,
            TARGET_DELIVERY_SUCCESSFUL,
            TARGET_DELIVERY_FAILED,
            UNKNOWN;

        }
    }
}

