/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.ApplicationAdapter;
import com.skype.Friend;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.StreamListener;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.List;

public final class Stream
extends SkypeObject {
    private final Application application;
    private final String id;
    private List<StreamListener> listeners = new ArrayList<StreamListener>();
    private SkypeExceptionHandler exceptionHandler;

    Stream(Application newApplication, String newId) {
        assert (newApplication != null);
        assert (newId != null);
        this.application = newApplication;
        this.id = newId;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof Stream) {
            Stream comparedStream = (Stream)compared;
            return this.getId().equals(comparedStream.getId());
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    public Application getApplication() {
        return this.application;
    }

    public String getId() {
        return this.id;
    }

    public Friend getFriend() {
        return User.getFriendInstance(this.getId().substring(0, this.getId().indexOf(58)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text) throws SkypeException {
        Utils.checkNotNull(text, "text");
        try {
            final Object wait = new Object();
            AbstractConnectorListener connectorListener = new AbstractConnectorListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void messageReceived(ConnectorMessageEvent event) {
                    String message = event.getMessage();
                    if (message.startsWith("APPLICATION " + Stream.this.getApplication().getName() + " SENDING ")) {
                        String[] streams;
                        String data = message.substring(("APPLICATION " + Stream.this.getApplication().getName() + " SENDING ").length());
                        if ("".equals(data)) {
                            Object object = wait;
                            synchronized (object) {
                                wait.notify();
                            }
                            return;
                        }
                        String[] stringArray = streams = data.split(" ");
                        int n = 0;
                        int n2 = stringArray.length;
                        while (n < n2) {
                            String stream = stringArray[n];
                            if ((stream = stream.substring(0, stream.indexOf(61))).equals(Stream.this.getId())) {
                                return;
                            }
                            ++n;
                        }
                        Object object = wait;
                        synchronized (object) {
                            wait.notify();
                        }
                    }
                }
            };
            ApplicationAdapter applicationListener = new ApplicationAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void disconnected(Stream stream) throws SkypeException {
                    if (stream == Stream.this) {
                        Object object = wait;
                        synchronized (object) {
                            wait.notify();
                        }
                    }
                }
            };
            Connector.getInstance().addConnectorListener(connectorListener);
            this.application.addApplicationListener(applicationListener);
            String header = "ALTER APPLICATION " + this.getApplication().getName() + " WRITE " + this.getId();
            Object object = wait;
            synchronized (object) {
                String result = Connector.getInstance().executeWithId(String.valueOf(header) + " " + text, header);
                Utils.checkError(result);
                try {
                    try {
                        wait.wait();
                    }
                    catch (InterruptedException e) {
                        throw new SkypeException("The writing was interrupted.", e);
                    }
                }
                finally {
                    Connector.getInstance().removeConnectorListener(connectorListener);
                    this.application.removeApplicationListener(applicationListener);
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void send(String datagram) throws SkypeException {
        Utils.checkNotNull(datagram, "datagram");
        try {
            String resposeHeader = "ALTER APPLICATION " + this.getApplication().getName() + " DATAGRAM " + this.getId();
            String command = String.valueOf(resposeHeader) + " " + datagram;
            String result = Connector.getInstance().execute(command, resposeHeader);
            Utils.checkError(result);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void addStreamListener(StreamListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeStreamListener(StreamListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    void fireTextReceived(String text) {
        StreamListener[] tmpListeners;
        assert (text != null);
        StreamListener[] streamListenerArray = tmpListeners = this.listeners.toArray(new StreamListener[0]);
        int n = 0;
        int n2 = streamListenerArray.length;
        while (n < n2) {
            StreamListener listener = streamListenerArray[n];
            try {
                listener.textReceived(text);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++n;
        }
    }

    void fireDatagramReceived(String datagram) {
        StreamListener[] tmpListeners;
        assert (datagram != null);
        StreamListener[] streamListenerArray = tmpListeners = this.listeners.toArray(new StreamListener[0]);
        int n = 0;
        int n2 = streamListenerArray.length;
        while (n < n2) {
            StreamListener listener = streamListenerArray[n];
            try {
                listener.datagramReceived(datagram);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++n;
        }
    }

    public void disconnect() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("ALTER APPLICATION " + this.application.getName() + " DISCONNECT " + this.getId());
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }
}

