/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.test;

import com.skype.connector.ConnectorUtils;
import com.skype.connector.test.Recorder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class CSVRecorder
extends Recorder {
    private PrintWriter writer;

    public CSVRecorder(String filePath) throws IOException {
        this(new File(filePath));
    }

    public CSVRecorder(File file) throws IOException {
        this(new FileWriter(file));
    }

    public CSVRecorder(Writer writer) {
        ConnectorUtils.checkNotNull("writer", writer);
        this.writer = new PrintWriter(new BufferedWriter(writer));
    }

    protected void recordReceivedMessage(long time, String message) {
        this.write("received", time, message);
    }

    protected void recordSentMessage(long time, String message) {
        this.write("sent", time, message);
    }

    private synchronized void write(String header, long time, String message) {
        this.writer.print(header);
        this.writer.print(',');
        this.writer.print(time);
        this.writer.print(',');
        this.writer.println(message);
    }

    public void close() {
        this.writer.close();
    }
}

