/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.CallStatusChangedListener;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Call
extends SkypeObject {
    private static final Map<String, Call> calls = new HashMap<String, Call>();
    private final String id;
    private final List<CallStatusChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private Status oldStatus;
    private SkypeExceptionHandler exceptionHandler;
    private boolean isCallListenerEventFired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Call getInstance(String string) {
        Map<String, Call> map = calls;
        synchronized (map) {
            if (!calls.containsKey(string)) {
                calls.put(string, new Call(string));
            }
            return calls.get(string);
        }
    }

    private Call(String string) {
        this.id = string;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Call) {
            return this.id.equals(((Call)object).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void addCallStatusChangedListener(CallStatusChangedListener callStatusChangedListener) {
        Utils.checkNotNull("listener", callStatusChangedListener);
        this.listeners.add(callStatusChangedListener);
    }

    public void removeCallStatusChangedListener(CallStatusChangedListener callStatusChangedListener) {
        Utils.checkNotNull("listener", callStatusChangedListener);
        this.listeners.remove(callStatusChangedListener);
    }

    void fireStatusChanged(Status status) {
        CallStatusChangedListener[] callStatusChangedListenerArray = this.listeners.toArray(new CallStatusChangedListener[0]);
        if (status == this.oldStatus) {
            return;
        }
        this.oldStatus = status;
        for (CallStatusChangedListener callStatusChangedListener : callStatusChangedListenerArray) {
            try {
                callStatusChangedListener.statusChanged(status);
            }
            catch (Throwable throwable) {
                Utils.handleUncaughtException(throwable, this.exceptionHandler);
            }
        }
    }

    public void hold() throws SkypeException {
        this.setStatus("ONHOLD");
    }

    public void resume() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void finish() throws SkypeException {
        this.setStatus("FINISHED");
    }

    public void answer() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void cancel() throws SkypeException {
        this.setStatus("FINISHED");
    }

    private void setStatus(String string) throws SkypeException {
        try {
            String string2 = Connector.getInstance().executeWithId("SET CALL " + this.getId() + " STATUS " + string, "CALL " + this.getId() + " STATUS ");
            Utils.checkError(string2);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public void forward() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER CALL " + this.getId() + " END FORWARD_CALL");
    }

    public void redirectToVoiceMail() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER CALL " + this.getId() + " END FORWARD_CALL");
    }

    public void send(DTMF dTMF) throws SkypeException {
        Utils.executeWithErrorCheck("SET CALL " + this.getId() + " DTMF " + dTMF.getType());
    }

    public Date getStartTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getPartner() throws SkypeException {
        return User.getInstance(this.getPartnerId());
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CALL", this.getId(), "STATUS"));
    }

    public int getDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("DURATION"));
    }

    public int getErrorCode() throws SkypeException {
        return Integer.parseInt(this.getProperty("FAILUREREASON"));
    }

    public void setReceiveVideoEnabled(boolean bl) throws SkypeException {
        String string = bl ? "START_VIDEO_SEND" : "STOP_VIDEO_SEND";
        try {
            String string2 = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + string);
            Utils.checkError(string2);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public boolean isReceiveVideoEnabled() throws SkypeException {
        VideoEnabledStatus videoEnabledStatus = VideoEnabledStatus.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (videoEnabledStatus) {
            case VIDEO_NONE: 
            case VIDEO_SEND_ENABLED: {
                return false;
            }
            case VIDEO_RECV_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public void setSendVideoEnabled(boolean bl) throws SkypeException {
        String string = bl ? "START_VIDEO_RECEIVE" : "STOP_VIDEO_RECEIVE";
        try {
            String string2 = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + string);
            Utils.checkError(string2);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public boolean isSendVideoEnabled() throws SkypeException {
        VideoEnabledStatus videoEnabledStatus = VideoEnabledStatus.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (videoEnabledStatus) {
            case VIDEO_NONE: 
            case VIDEO_RECV_ENABLED: {
                return false;
            }
            case VIDEO_SEND_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public VideoStatus getReceiveVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_RECEIVE_STATUS"));
    }

    public VideoStatus getSendVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_SEND_STATUS"));
    }

    public String getConferenceId() throws SkypeException {
        return this.getProperty("CONF_ID");
    }

    public String getParticipantsCount() throws SkypeException {
        return this.getProperty("CONF_PARTICIPANTS_COUNT");
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("CALL", this.getId(), string);
    }

    boolean isCallListenerEventFired() {
        return this.isCallListenerEventFired;
    }

    void setCallListenerEventFired(boolean bl) {
        this.isCallListenerEventFired = bl;
    }

    public void setFileInput(File file) throws SkypeException {
        if (file == null) {
            this.clearFileInput();
            return;
        }
        Map<String, String> map = this.getInputStreams();
        map.put("FILE", file.getAbsolutePath());
        this.setInputStreams(map);
    }

    public void clearFileInput() throws SkypeException {
        Map<String, String> map = this.getInputStreams();
        map.remove("FILE");
        this.setInputStreams(map);
    }

    public void setFileOutput(File file) throws SkypeException {
        if (file == null) {
            this.clearFileOutput();
            return;
        }
        Map<String, String> map = this.getOutputStreams();
        map.put("FILE", file.getAbsolutePath());
        this.setOutputStreams(map);
    }

    public void clearFileOutput() throws SkypeException {
        Map<String, String> map = this.getOutputStreams();
        map.remove("FILE");
        this.setOutputStreams(map);
    }

    public void setFileCaptureMic(File file) throws SkypeException {
        if (file == null) {
            this.clearFileCaptureMic();
            return;
        }
        Map<String, String> map = this.getCaptureMicStreams();
        map.put("FILE", file.getAbsolutePath());
        this.setCaptureMicStreams(map);
    }

    public void clearFileCaptureMic() throws SkypeException {
        Map<String, String> map = this.getCaptureMicStreams();
        map.remove("FILE");
        this.setCaptureMicStreams(map);
    }

    public void setPortInput(int n) throws SkypeException {
        if (n <= 0) {
            this.clearPortInput();
            return;
        }
        Map<String, String> map = this.getInputStreams();
        map.put("PORT", "" + n);
        this.setInputStreams(map);
    }

    public void clearPortInput() throws SkypeException {
        Map<String, String> map = this.getInputStreams();
        map.remove("PORT");
        this.setInputStreams(map);
    }

    public void setPortOutput(int n) throws SkypeException {
        if (n <= 0) {
            this.clearPortOutput();
            return;
        }
        Map<String, String> map = this.getOutputStreams();
        map.put("PORT", "" + n);
        this.setOutputStreams(map);
    }

    public void clearPortOutput() throws SkypeException {
        Map<String, String> map = this.getOutputStreams();
        map.remove("PORT");
        this.setOutputStreams(map);
    }

    public void setPortCaptureMic(int n) throws SkypeException {
        if (n <= 0) {
            this.clearPortCaptureMic();
            return;
        }
        Map<String, String> map = this.getCaptureMicStreams();
        map.put("PORT", "" + n);
        this.setCaptureMicStreams(map);
    }

    public void clearPortCaptureMic() throws SkypeException {
        Map<String, String> map = this.getCaptureMicStreams();
        map.remove("PORT");
        this.setCaptureMicStreams(map);
    }

    private Map<String, String> getInputStreams() throws SkypeException {
        return this.getStreams("INPUT");
    }

    private Map<String, String> getOutputStreams() throws SkypeException {
        return this.getStreams("OUTPUT");
    }

    private Map<String, String> getCaptureMicStreams() throws SkypeException {
        return this.getStreams("CAPTURE_MIC");
    }

    private Map<String, String> getStreams(String string) throws SkypeException {
        String string2 = Utils.getProperty("CALL", this.getId(), string);
        Utils.checkError(string2);
        if ("".equals(string2)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : string2.split(", ")) {
            int n = string3.indexOf(61);
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 2, string3.length() - 1);
            hashMap.put(string4, string5);
        }
        return hashMap;
    }

    private void setInputStreams(Map<String, String> map) throws SkypeException {
        this.setStreams("INPUT", map);
    }

    private void setOutputStreams(Map<String, String> map) throws SkypeException {
        this.setStreams("OUTPUT", map);
    }

    private void setCaptureMicStreams(Map<String, String> map) throws SkypeException {
        this.setStreams("CAPTURE_MIC", map);
    }

    private void setStreams(String string, Map<String, String> map) throws SkypeException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : map.keySet()) {
                stringBuilder.append(" ");
                stringBuilder.append(string2);
                stringBuilder.append("=\"");
                stringBuilder.append(map.get(string2));
                stringBuilder.append("\"");
            }
            String string3 = Connector.getInstance().execute("ALTER CALL " + this.getId() + " SET_" + string + stringBuilder);
            Utils.checkError(string3);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    public boolean canTransferTo(String string) throws SkypeException {
        try {
            String string2 = "GET CALL " + this.getId() + " CAN_TRANSFER " + string;
            String string3 = "CALL " + this.getId() + " CAN_TRANSFER " + string + " ";
            String string4 = Connector.getInstance().execute(string2, string3);
            Utils.checkError(string4);
            return Boolean.parseBoolean(string4.substring(string3.length()));
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return false;
        }
    }

    public void transferTo(String ... stringArray) throws SkypeException {
        Utils.checkNotNull("skypeIds", stringArray);
        try {
            String string = Connector.getInstance().execute("ALTER CALL " + this.getId() + " TRANSFER \"" + Utils.convertToCommaSeparatedString(stringArray) + "\"");
            Utils.checkError(string);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VideoEnabledStatus {
        VIDEO_NONE,
        VIDEO_SEND_ENABLED,
        VIDEO_RECV_ENABLED,
        VIDEO_BOTH_ENABLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DTMF {
        TYPE_0,
        TYPE_1,
        TYPE_2,
        TYPE_3,
        TYPE_4,
        TYPE_5,
        TYPE_6,
        TYPE_7,
        TYPE_8,
        TYPE_9,
        TYPE_SHARP('#'),
        TYPE_ASTERISK('*');

        private final char type;

        private DTMF() {
            this.type = this.name().charAt("TYPE_".length());
        }

        private DTMF(char c) {
            this.type = c;
        }

        char getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VideoStatus {
        NOT_AVAILABLE,
        AVAILABLE,
        STARTING,
        REJECTED,
        RUNNING,
        STOPPING,
        PAUSED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCOMING_PSTN,
        OUTGOING_PSTN,
        INCOMING_P2P,
        OUTGOING_P2P;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNPLACED,
        ROUTING,
        EARLYMEDIA,
        FAILED,
        RINGING,
        INPROGRESS,
        ONHOLD,
        FINISHED,
        MISSED,
        REFUSED,
        BUSY,
        CANCELLED,
        VM_BUFFERING_GREETING,
        VM_PLAYING_GREETING,
        VM_RECORDING,
        VM_UPLOADING,
        VM_SENT,
        VM_CANCELLED,
        VM_FAILED,
        TRANSFERRING,
        TRANSFERRED,
        LOCALHOLD,
        REMOTEHOLD,
        WAITING_REDIAL_COMMAND,
        REDIAL_PENDING;

    }
}

