/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Chat;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ChatMessage
extends SkypeObject {
    private static final Map<String, ChatMessage> chatMessages = new HashMap<String, ChatMessage>();
    private final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ChatMessage getInstance(String string) {
        Map<String, ChatMessage> map = chatMessages;
        synchronized (map) {
            if (!chatMessages.containsKey(string)) {
                chatMessages.put(string, new ChatMessage(string));
            }
            return chatMessages.get(string);
        }
    }

    private ChatMessage(String string) {
        this.id = string;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ChatMessage) {
            ChatMessage chatMessage = (ChatMessage)object;
            return this.getId().equals(chatMessage.getId());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public Date getTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getSender() throws SkypeException {
        return User.getInstance(this.getSenderId());
    }

    public String getSenderId() throws SkypeException {
        return this.getProperty("FROM_HANDLE");
    }

    public String getSenderDisplayName() throws SkypeException {
        return this.getProperty("FROM_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CHATMESSAGE", this.getId(), "STATUS"));
    }

    public LeaveReason getLeaveReason() throws SkypeException {
        return LeaveReason.valueOf(this.getProperty("LEAVEREASON"));
    }

    public String getContent() throws SkypeException {
        return this.getProperty("BODY");
    }

    public void setContent(String string) throws SkypeException {
        this.setProperty("BODY", string);
    }

    public boolean isEditable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_EDITABLE"));
    }

    public Chat getChat() throws SkypeException {
        return Chat.getInstance(this.getProperty("CHATNAME"));
    }

    public User[] getAllUsers() throws SkypeException {
        String string = this.getProperty("USERS");
        if ("".equals(string)) {
            return new User[0];
        }
        String[] stringArray = string.split(" ");
        User[] userArray = new User[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            userArray[i] = User.getInstance(stringArray[i]);
        }
        return userArray;
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("CHATMESSAGE", this.getId(), string);
    }

    private void setProperty(String string, String string2) throws SkypeException {
        Utils.setProperty("CHATMESSAGE", this.getId(), string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LeaveReason {
        USER_NOT_FOUND,
        USER_INCAPABLE,
        ADDER_MUST_BE_FRIEND,
        ADDED_MUST_BE_AUTHORIZED,
        UNSUBSCRIBE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        SENDING,
        SENT,
        RECEIVED,
        READ;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SETTOPIC,
        SAID,
        ADDEDMEMBERS,
        SAWMEMBERS,
        CREATEDCHATWITH,
        LEFT,
        UNKNOWN;

    }
}

