/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.EventMessageListener;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class EventMessage
extends SkypeObject {
    private static final Map<String, EventMessage> eventMessages = Collections.synchronizedMap(new HashMap());
    private static final AtomicInteger eventMessageNumber = new AtomicInteger();
    private static Object eventMessageListenerMutex = new Object();
    private static ConnectorListener eventMessageListener;
    private final String id = "eventMessage" + eventMessageNumber.getAndIncrement();
    private final String caption;
    private final String hint;
    private final List<EventMessageListener> eventMessageListeners = Collections.synchronizedList(new ArrayList());

    static EventMessage getInstance(String string) {
        return eventMessages.get(string);
    }

    static EventMessage addEventMessage(String string, String string2) {
        EventMessage eventMessage = new EventMessage(string, string2);
        eventMessages.put(eventMessage.getId(), eventMessage);
        return eventMessage;
    }

    EventMessage(String string, String string2) {
        this.caption = string;
        this.hint = string2;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof EventMessage) {
            return this.getId().equals(((EventMessage)object).getId());
        }
        return false;
    }

    String getId() {
        return this.id;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getHint() {
        return this.hint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventMessageListener(EventMessageListener eventMessageListener) throws SkypeException {
        Utils.checkNotNull("listener", eventMessageListener);
        this.eventMessageListeners.add(eventMessageListener);
        Object object = eventMessageListenerMutex;
        synchronized (object) {
            if (EventMessage.eventMessageListener == null) {
                EventMessage.eventMessageListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string;
                        EventMessage eventMessage;
                        String string2 = connectorMessageEvent.getMessage();
                        if (string2.startsWith("EVENT ") && string2.endsWith(" CLICKED") && (eventMessage = EventMessage.getInstance(string = string2.substring("EVENT ".length(), string2.length() - " CLICKED".length()))) != null) {
                            EventMessageListener[] eventMessageListenerArray;
                            for (EventMessageListener eventMessageListener : eventMessageListenerArray = eventMessage.eventMessageListeners.toArray(new EventMessageListener[0])) {
                                try {
                                    eventMessageListener.eventMessageClicked();
                                }
                                catch (Throwable throwable) {
                                    Skype.handleUncaughtException(throwable);
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(EventMessage.eventMessageListener);
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventMessageListener(EventMessageListener eventMessageListener) {
        Utils.checkNotNull("listener", eventMessageListener);
        this.eventMessageListeners.remove(eventMessageListener);
        Object object = eventMessageListenerMutex;
        synchronized (object) {
            boolean bl = true;
            for (EventMessage eventMessage : eventMessages.values()) {
                bl &= eventMessage.eventMessageListeners.isEmpty();
            }
            if (bl) {
                Connector.getInstance().removeConnectorListener(EventMessage.eventMessageListener);
                EventMessage.eventMessageListener = null;
            }
        }
    }

    public void dispose() throws SkypeException {
        try {
            String string = "DELETE EVENT " + this.getId();
            String string2 = Connector.getInstance().execute(string);
            Utils.checkError(string2);
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
        }
    }
}

