/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.analysis.NFAState;
import org.antlr.test.BaseTest;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;

public class TestNFAConstruction
extends BaseTest {
    public void testA() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A;");
        String string = ".s0->.s1\n.s1->.s2\n.s2-A->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAB() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A B ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2-A->.s3\n.s3-B->.s4\n.s4->:s5\n:s5-EOF->.s6\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAorB() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A | B {;} ;");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s7\n.s10->.s4\n.s2-A->.s3\n.s3->.s4\n.s4->:s5\n.s7->.s8\n.s8-B->.s9\n.s9-{}->.s10\n:s5-EOF->.s6\n";
        this.checkRule(grammar, "a", string);
    }

    public void testRangeOrRange() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : ('a'..'c' 'h' | 'q' 'j'..'l') ;");
        String string = ".s0->.s1\n.s1->.s2\n.s10-'q'->.s11\n.s11-'j'..'l'->.s12\n.s12->.s6\n.s2->.s3\n.s2->.s9\n.s3-'a'..'c'->.s4\n.s4-'h'->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n:s7-<EOT>->.s8\n";
        this.checkRule(grammar, "A", string);
    }

    public void testRange() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : 'a'..'c' ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2-'a'..'c'->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(grammar, "A", string);
    }

    public void testCharSetInParser() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : A|'b' ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2-A..'b'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
    }

    public void testABorCD() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A B | C D;");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10-D->.s11\n.s11->.s5\n.s2-A->.s3\n.s3-B->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-C->.s10\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "a", string);
    }

    public void testbA() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b A ;\nb : B ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4->.s5\n.s5-B->.s6\n.s6->:s7\n.s8-A->.s9\n.s9->:s10\n:s10-EOF->.s11\n:s7->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testbA_bC() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b A ;\nb : B ;\nc : b C;");
        String string = ".s0->.s1\n.s1->.s2\n.s12->.s13\n.s13-C->.s14\n.s14->:s15\n.s2->.s3\n.s3->.s4\n.s4->.s5\n.s5-B->.s6\n.s6->:s7\n.s8-A->.s9\n.s9->:s10\n:s10-EOF->.s11\n:s15-EOF->.s16\n:s7->.s12\n:s7->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAorEpsilon() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A | ;");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s7\n.s2-A->.s3\n.s3->.s4\n.s4->:s5\n.s7->.s8\n.s8->.s9\n.s9->.s4\n:s5-EOF->.s6\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A)?;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "a", string);
    }

    public void testNakedAoptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A?;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAorBthenC() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A | B) C;");
    }

    public void testAplus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A)+;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testNakedAplus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A+;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAplusNonGreedy() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : (options {greedy=false;}:'0'..'9')+ ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-'0'..'9'->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-<EOT>->.s8\n";
        this.checkRule(grammar, "A", string);
    }

    public void testAorBplus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A | B{action})+ ;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-B->.s12\n.s12-{}->.s13\n.s13->.s6\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAorBorEmptyPlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A | B | )+ ;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s10->.s13\n.s11-B->.s12\n.s12->.s6\n.s13->.s14\n.s14->.s15\n.s15->.s6\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A)*;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testNestedAstar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A*)*;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->:s11\n.s13->.s8\n.s14->.s10\n.s2->.s14\n.s2->.s3\n.s3->.s4\n.s4->.s13\n.s4->.s5\n.s5->.s6\n.s6-A->.s7\n.s7->.s5\n.s7->.s8\n.s8->.s9\n.s9->.s10\n.s9->.s3\n:s11-EOF->.s12\n";
        this.checkRule(grammar, "a", string);
    }

    public void testPlusNestedInStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A+)*;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->:s11\n.s13->.s10\n.s2->.s13\n.s2->.s3\n.s3->.s4\n.s4->.s5\n.s5->.s6\n.s6-A->.s7\n.s7->.s5\n.s7->.s8\n.s8->.s9\n.s9->.s10\n.s9->.s3\n:s11-EOF->.s12\n";
        this.checkRule(grammar, "a", string);
    }

    public void testStarNestedInPlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A*)+;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->:s11\n.s13->.s8\n.s2->.s3\n.s3->.s4\n.s4->.s13\n.s4->.s5\n.s5->.s6\n.s6-A->.s7\n.s7->.s5\n.s7->.s8\n.s8->.s9\n.s9->.s10\n.s9->.s3\n:s11-EOF->.s12\n";
        this.checkRule(grammar, "a", string);
    }

    public void testNakedAstar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A*;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-A->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAorBstar() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : (A | B{action})* ;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-B->.s12\n.s12-{}->.s13\n.s13->.s6\n.s14->.s7\n.s2->.s14\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAorBOptionalSubrule() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ( A | B )? ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A..B->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "a", string);
    }

    public void testPredicatedAorB() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A | {p2}? B ;");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10-B->.s11\n.s11->.s5\n.s2-{p1}?->.s3\n.s3-A->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-{p2}?->.s10\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "a", string);
    }

    public void testMultiplePredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? {p1a}? A | {p2}? B | {p3} b;\nb : {p4}? B ;");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s9\n.s10-{p2}?->.s11\n.s11-B->.s12\n.s12->.s6\n.s13->.s14\n.s14-{}->.s15\n.s15->.s16\n.s16->.s17\n.s17->.s18\n.s18-{p4}?->.s19\n.s19-B->.s20\n.s2-{p1}?->.s3\n.s20->:s21\n.s22->.s6\n.s3-{p1a}?->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n.s9->.s13\n:s21->.s22\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testSets() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ( A | B )+ ;\nb : ( A | B{;} )+ ;\nc : (A|B) (A|B) ;\nd : ( A | B )* ;\ne : ( A | B )? ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-A..B->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
        string = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-B->.s12\n.s12-{}->.s13\n.s13->.s6\n.s2->.s3\n.s3->.s10\n.s3->.s4\n.s4-A->.s5\n.s5->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "b", string);
        string = ".s0->.s1\n.s1->.s2\n.s2-A..B->.s3\n.s3-A..B->.s4\n.s4->:s5\n:s5-EOF->.s6\n";
        this.checkRule(grammar, "c", string);
        string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-A..B->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "d", string);
        string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s8\n.s3-A..B->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s5\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "e", string);
    }

    public void testNotSet() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\ntokens { A; B; C; }\na : ~A ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-B..C->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
        String string2 = "1:8: parser grammar P;\na : ~ A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testNotSingletonBlockSet() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\ntokens { A; B; C; }\na : ~(A) ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-B..C->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
        String string2 = "1:8: parser grammar P;\na : ~ ( A ) ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testNotCharSet() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : ~'3' ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(grammar, "A", string);
        String string2 = "1:7: lexer grammar P;\nA : ~ '3' ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testNotBlockSet() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : ~('3'|'b') ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'a', 'c'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(grammar, "A", string);
        String string2 = "1:7: lexer grammar P;\nA : ~ ( '3' | 'b' ) ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testNotSetLoop() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : ~('3')* ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-{'\\u0000'..'2', '4'..'\\uFFFE'}->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-<EOT>->.s8\n";
        this.checkRule(grammar, "A", string);
        String string2 = "1:7: lexer grammar P;\nA : (~ ( '3' ) )* ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testNotBlockSetLoop() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : ~('3'|'b')* ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-{'\\u0000'..'2', '4'..'a', 'c'..'\\uFFFE'}->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-<EOT>->.s8\n";
        this.checkRule(grammar, "A", string);
        String string2 = "1:7: lexer grammar P;\nA : (~ ( '3' | 'b' ) )* ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testSetsInCombinedGrammarSentToLexer() throws Exception {
        Grammar grammar = new Grammar("grammar t;\nA : '{' ~('}')* '}';\n");
        String string = grammar.getLexerGrammar();
        String string2 = "lexer grammar t;\n\n// $ANTLR src \"<string>\" 2\nA : '{' ~('}')* '}';\n";
        TestNFAConstruction.assertEquals((String)string, (String)string2);
    }

    public void testLabeledNotSet() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\ntokens { A; B; C; }\na : t=~A ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-B..C->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
        String string2 = "1:8: parser grammar P;\na : t=~ A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testLabeledNotCharSet() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : t=~'3' ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(grammar, "A", string);
        String string2 = "1:7: lexer grammar P;\nA : t=~ '3' ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testLabeledNotBlockSet() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : t=~('3'|'b') ;\n");
        String string = ".s0->.s1\n.s1->.s2\n.s2-{'\\u0000'..'2', '4'..'a', 'c'..'\\uFFFE'}->.s3\n.s3->:s4\n:s4-<EOT>->.s5\n";
        this.checkRule(grammar, "A", string);
        String string2 = "1:7: lexer grammar P;\nA : t=~ ( '3' | 'b' ) ;\nTokens : A ;";
        TestNFAConstruction.assertEquals((String)string2, (String)grammar.toString());
    }

    public void testEscapedCharLiteral() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : '\\n';");
        String string = ".s0->.s1\n.s1->.s2\n.s2-'\\n'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
    }

    public void testEscapedStringLiteral() throws Exception {
        Grammar grammar = new Grammar("grammar P;\na : 'a\\nb\\u0030c\\'';");
        String string = ".s0->.s1\n.s1->.s2\n.s2-'a\\nb\\u0030c\\''->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_RuleBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : 'a'{;}|'b';");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s9\n.s10-'b'->.s11\n.s11->.s6\n.s2-{synpred1_t}?->.s3\n.s3-'a'->.s4\n.s4-{}->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s10\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_RuleSetBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : 'a'|'b';");
        String string = ".s0->.s1\n.s1->.s2\n.s2-'a'..'b'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_SimpleBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b') ;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s11-'b'->.s12\n.s12->.s7\n.s2->.s10\n.s2->.s3\n.s3-{synpred1_t}?->.s4\n.s4-'a'->.s5\n.s5-{}->.s6\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_SetBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b') ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2-'a'..'b'->.s3\n.s3->:s4\n:s4-EOF->.s5\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_StarBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b')* ;");
        String string = ".s0->.s1\n.s1->.s2\n.s12->.s13\n.s13-{synpred2_t}?->.s14\n.s14-'b'->.s15\n.s15->.s8\n.s16->.s9\n.s2->.s16\n.s2->.s3\n.s3->.s12\n.s3->.s4\n.s4-{synpred1_t}?->.s5\n.s5-'a'->.s6\n.s6-{}->.s7\n.s7->.s8\n.s8->.s3\n.s8->.s9\n.s9->:s10\n:s10-EOF->.s11\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_StarSetBlock_IgnoresPreds() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b')* ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3->.s4\n.s4-'a'..'b'->.s5\n.s5->.s3\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_StarSetBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b'{;})* ;");
        String string = ".s0->.s1\n.s1->.s2\n.s11->.s12\n.s12-{synpred2_t}?->.s13\n.s13-'b'->.s14\n.s14-{}->.s15\n.s15->.s7\n.s16->.s8\n.s2->.s16\n.s2->.s3\n.s3->.s11\n.s3->.s4\n.s4-{synpred1_t}?->.s5\n.s5-'a'->.s6\n.s6->.s7\n.s7->.s3\n.s7->.s8\n.s8->:s9\n:s9-EOF->.s10\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_StarBlock1Alt() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')* ;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->.s7\n.s2->.s10\n.s2->.s3\n.s3->.s4\n.s4-{synpred1_t}?->.s5\n.s5-'a'->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_PlusBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b')+ ;");
        String string = ".s0->.s1\n.s1->.s2\n.s12->.s13\n.s13-{synpred2_t}?->.s14\n.s14-'b'->.s15\n.s15->.s8\n.s2->.s3\n.s3->.s12\n.s3->.s4\n.s4-{synpred1_t}?->.s5\n.s5-'a'->.s6\n.s6-{}->.s7\n.s7->.s8\n.s8->.s3\n.s8->.s9\n.s9->:s10\n:s10-EOF->.s11\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_PlusSetBlock() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'|'b'{;})+ ;");
        String string = ".s0->.s1\n.s1->.s2\n.s11->.s12\n.s12-{synpred2_t}?->.s13\n.s13-'b'->.s14\n.s14-{}->.s15\n.s15->.s7\n.s2->.s3\n.s3->.s11\n.s3->.s4\n.s4-{synpred1_t}?->.s5\n.s5-'a'->.s6\n.s6->.s7\n.s7->.s3\n.s7->.s8\n.s8->:s9\n:s9-EOF->.s10\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_PlusBlock1Alt() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')+ ;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s3->.s4\n.s4-{synpred1_t}?->.s5\n.s5-'a'->.s6\n.s6->.s3\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_OptionalBlock2Alts() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a'{;}|'b')?;");
        String string = ".s0->.s1\n.s1->.s2\n.s10->.s11\n.s10->.s14\n.s11-{synpred2_t}?->.s12\n.s12-'b'->.s13\n.s13->.s7\n.s14->.s7\n.s2->.s10\n.s2->.s3\n.s3-{synpred1_t}?->.s4\n.s4-'a'->.s5\n.s5-{}->.s6\n.s6->.s7\n.s7->:s8\n:s8-EOF->.s9\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_OptionalBlock1Alt() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')?;");
        String string = ".s0->.s1\n.s1->.s2\n.s2->.s3\n.s2->.s9\n.s3-{synpred1_t}?->.s4\n.s4-'a'->.s5\n.s5->.s6\n.s6->:s7\n.s9->.s6\n:s7-EOF->.s8\n";
        this.checkRule(grammar, "a", string);
    }

    public void testAutoBacktracking_ExistingPred() throws Exception {
        Grammar grammar = new Grammar("grammar t;\noptions {backtrack=true;}\na : ('a')=> 'a' | 'b';");
        String string = ".s0->.s1\n.s1->.s2\n.s1->.s8\n.s10->.s5\n.s2-{synpred1_t}?->.s3\n.s3-'a'->.s4\n.s4->.s5\n.s5->:s6\n.s8->.s9\n.s9-'b'->.s10\n:s6-EOF->.s7\n";
        this.checkRule(grammar, "a", string);
    }

    private void checkRule(Grammar grammar, String string, String string2) {
        grammar.buildNFA();
        NFAState nFAState = grammar.getRuleStartState(string);
        FASerializer fASerializer = new FASerializer(grammar);
        String string3 = fASerializer.serialize(nFAState);
        TestNFAConstruction.assertEquals((String)string2, (String)string3);
    }
}

