package jp.kirikiri.tjs2;

import java.util.ArrayList;

class ArrayObject extends CustomObject {

	public ArrayObject() {
		super();
		mCallFinalize = false;
	}
	protected void finalize() {

	}
	public void clear(ArrayNI ni) {
		// clear members
		final int count = ni.mItems.size();
		for( int i = 0; i < count; i++) {
			Variant v = ni.mItems.get(i);
			v.clear();
		}
		ni.mItems.clear();
	}
	public void erase(ArrayNI ni, int num) throws TJSException {
		if(num < 0) num += ni.mItems.size();
		if(num < 0) throw new TJSException(Error.RangeError);
		if( num >= ni.mItems.size() ) throw new TJSException(Error.RangeError);

		ni.mItems.remove(num);
	}
	public int remove(ArrayNI ni, Variant ref, boolean removeall) {
		int count = 0;
		ArrayList<Integer> todelete = new ArrayList<Integer>();
		final int arrayCount = ni.mItems.size();
		for( int i = 0; i < arrayCount; i++ ) {
			Variant v = ni.mItems.get(i);
			if(ref.discernCompareInternal(v)) {
				count++;
				todelete.add(i);
				if(!removeall) break;
			}
		}

		// list objects up
		final int delCount = todelete.size();
		for( int i = 0; i < delCount; i++  ) {
			int pos = todelete.get(i);
			Variant v = ni.mItems.get(pos);
			v.clear();
		}
		// remove items found
		for( int i = delCount - 1; i >= 0; i-- ) {
			ni.mItems.remove( todelete.get(i).intValue() );
		}
		return count;
	}
	public void insert(ArrayNI ni, Variant val, int num) throws TJSException {
		if(num < 0) num += ni.mItems.size();
		if(num < 0) throw new TJSException(Error.RangeError);
		int count = ni.mItems.size();
		if(num > count) throw new TJSException(Error.RangeError);

		ni.mItems.add( num, val );
	}
	public void add(ArrayNI ni, Variant val) {
		ni.mItems.add(val);
	}
	public void insert(ArrayNI ni, Variant[] val, int num ) throws TJSException {
		if(num < 0) num += ni.mItems.size();
		if(num < 0) throw new TJSException(Error.RangeError);
		int count = ni.mItems.size();
		if(num > count) throw new TJSException(Error.RangeError);

		int end = val.length;
		ni.mItems.ensureCapacity( count+end );
		for( int i = 0; i < end; i++ ) {
			ni.mItems.add( num+i, val[i] );
		}
	}
}

