package jp.kirikiri.tvp2.env;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

import javax.imageio.ImageIO;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.GraphicsLoader;


public class NativeImageLoader {

	static public BufferedImage loadImage( InputStream stream ) {
		try {
			BufferedImage img = null;
			img = ImageIO.read(stream);
			return img;
		} catch (IOException e) {
			return null;
		}
	}

	static public NativeImageBuffer loadImage( BinaryStream stream, final String ext, HashMap<String,String> metainfo, boolean isGrayscale ) throws TJSException {
		BufferedImage img = null;
		if( ".tlg".equalsIgnoreCase(ext) || ".tlg5".equalsIgnoreCase(ext ) || ".tlg6".equalsIgnoreCase(ext ) ) {
			img = TLGLoader.loadTLG(stream, GraphicsLoader.glmNormal, metainfo );
		}
		if( img == null ) {
			try {
				img = ImageIO.read(stream.getInputStream());
			} catch (IOException e) {
			}
		}
		if( img == null ) return null;

		if( isGrayscale != true ) {
			/*
			if( img.getType() != BufferedImage.TYPE_INT_ARGB_PRE ) {
				if( img.getType() == BufferedImage.TYPE_INT_ARGB ) {
					img.coerceData(true); // alpha 乗算
				} else {
					// 常に変換するようにしてみる、DataBuffer は int になるので、自前で処理するのは速くなる
					BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), BufferedImage.TYPE_INT_ARGB_PRE );
					Graphics2D g = img2.createGraphics();
					g.drawImage(img, 0, 0, null );
					g.dispose();
					img = img2;
				}
			}
			*/
			final int imgType = img.getType();
			if( imgType != BufferedImage.TYPE_INT_ARGB && imgType != BufferedImage.TYPE_INT_ARGB_PRE ) {
				// 常に変換するようにしてみる、DataBuffer は int になるので、自前で処理するのは速くなる
				BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), BufferedImage.TYPE_INT_ARGB );
				Graphics2D g = img2.createGraphics();
				g.drawImage(img, 0, 0, null );
				g.dispose();
				img = img2;
			}
		}
		return new NativeImageBuffer(img);
	}
}
