package jp.kirikiri.tvp2.sound;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.EventManager;


public class WaveSoundBufferClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_BADPARAMCOUNT	= -1004,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0;

	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;
	static private final int
		MEMBERENSURE	= 0x00000200,	// create a member if not exists
		IGNOREPROP		= 0x00000800;	// ignore property invoking

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "WaveSoundBuffer";

	protected NativeInstance createNativeInstance() {
		return new WaveSoundBufferNI();
	}

	public WaveSoundBufferClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				int hr = _this.construct(param, objthis);
				if( hr < 0 ) return hr;
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "open", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 1) return E_BADPARAMCOUNT;
				_this.open( param[0].asString() );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "play", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.play();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "stop", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.stop();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "fade", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 2) return E_BADPARAMCOUNT;
				int to;
				int time;
				int delay = 0;
				to = param[0].asInteger();
				time = param[1].asInteger();
				if( param.length >= 3 && param[2].isVoid() != true )
					delay = param[2].asInteger();
				_this.fade( to, time, delay );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "stopFade", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.stopFade(false,true);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "setPos", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				if( param.length < 3) return E_BADPARAMCOUNT;
				double x, y , z;
				x = param[0].asDouble();
				y = param[1].asDouble();
				z = param[2].asDouble();

				_this.setPos( x, y, z );
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		// event
		registerNCM( "onStatusChanged", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				VariantClosure obj = _this.getActionOwner();
				if( obj.mObject != null ) {
					if( param.length < 1 ) return E_BADPARAMCOUNT;

					Dispatch2 evobj = EventManager.createEventObject( "onStatusChanged", objthis, objthis );
					Variant evval = new Variant(evobj, evobj);
					// set member
					evobj.propSet( MEMBERENSURE|IGNOREPROP, "status", param[0], evobj );

					Variant[] pevval = {evval};
					obj.funcCall( 0, EventManager.ActionName, result, pevval, null );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onFadeCompleted", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				VariantClosure obj = _this.getActionOwner();
				if( obj.mObject != null ) {
					Dispatch2 evobj = EventManager.createEventObject( "onFadeCompleted", objthis, objthis );
					Variant evval = new Variant(evobj, evobj);

					Variant[] pevval = {evval};
					obj.funcCall( 0, EventManager.ActionName, result, pevval, null );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "onLabel", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				VariantClosure obj = _this.getActionOwner();
				if( obj.mObject != null ) {
					if( param.length < 1 ) return E_BADPARAMCOUNT;

					Dispatch2 evobj = EventManager.createEventObject( "onLabel", objthis, objthis );
					Variant evval = new Variant(evobj, evobj);
					// set member
					evobj.propSet( MEMBERENSURE|IGNOREPROP, "name", param[0], evobj );

					Variant[] pevval = {evval};
					obj.funcCall( 0, EventManager.ActionName, result, pevval, null );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "position", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getPosition() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setPosition( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "samplePosition", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getSamplePosition() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setSamplePosition( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "paused", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getPaused() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setPaused( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "totalTime", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getTotalTime() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "looping", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getLooping() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setLooping( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "volume", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getVolume() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setVolume( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "volume2", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getVolume2() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setVolume2( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "pan", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getPan() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setPan( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "posX", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getPosX() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setPosX( param.asDouble() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "posY", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getPosY() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setPosY( param.asDouble() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "posZ", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getPosZ() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setPosZ( param.asDouble() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "status", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getStatusString() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "frequency", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getFrequency() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setFrequency( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "bits", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getGitsPerSample() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "channels", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getChannels() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "flags", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 dsp = _this.getWaveFlagsObject();
				result.set( dsp, dsp );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "labels", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 dsp = _this.getWaveLabelsObject();
				result.set( dsp, dsp );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "filters", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				WaveSoundBufferNI _this = (WaveSoundBufferNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				Dispatch2 dsp = _this.getWaveFiltersObject();
				result.set( dsp, dsp );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "globalVolume", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.SoundMixer.getGlobalVolume() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				TVP.SoundMixer.setGlobalVolume( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		// sgfmNeverMute = 0, sgfmMuteOnMinimize = 1, sgfmMuteOnDeactivate = 2
		registerNCM( "globalFocusMode", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( 0 ); // sgfmNeverMute ミュートしない
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				return S_OK;	// 設定不可
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );
	}

}
